/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.JarURLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger _Logger = LoggerFactory.getLogger(ClassUtil.class);
    private static volatile Map<Class<?>, String> _SimpleNameCache = Collections.emptyMap();

    public static Class<?> forName(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz, true, ClassUtil.getDefaultClassLoader());
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtil.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static List<Class<?>> getAllClassByInterface(Class<?> c) throws IOException {
        String packageName;
        List<Class<?>> allClass;
        ArrayList returnClassList = null;
        if (c.isInterface() && (allClass = ClassUtil.getClasses(packageName = c.getPackage().getName())) != null) {
            returnClassList = new ArrayList();
            for (Class<?> classes : allClass) {
                if (!c.isAssignableFrom(classes) || c.equals(classes)) continue;
                returnClassList.add(classes);
            }
        }
        return returnClassList;
    }

    public static String[] getPackageAllClassName(String classLocation, String packageName) {
        String[] packagePathSplit = packageName.split("[.]");
        String realClassLocation = classLocation;
        int packageLength = packagePathSplit.length;
        int i = 0;
        while (i < packageLength) {
            realClassLocation = String.valueOf(realClassLocation) + File.separator + packagePathSplit[i];
            ++i;
        }
        File packeageDir = new File(realClassLocation);
        if (packeageDir.isDirectory()) {
            String[] allClassName = packeageDir.list();
            return allClassName;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Class<?>> getClasses(String packageName) {
        classes = new ArrayList<Class<?>>();
        recursive = true;
        packageDirName = packageName.replace('.', '/');
        try {
            dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            if (true) ** GOTO lbl47
        }
        catch (IOException e) {
            ClassUtil._Logger.warn("\u5ffd\u7565\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
            return classes;
        }
        do {
            if ("file".equals(protocol = (url = dirs.nextElement()).getProtocol())) {
                try {
                    filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                }
                catch (IOException e) {
                    ClassUtil._Logger.warn("\u5ffd\u7565\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                ClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            try {
                jar = ((JarURLConnection)url.openConnection()).getJarFile();
            }
            catch (IOException e) {
                ClassUtil._Logger.warn("\u5ffd\u7565\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
                continue;
            }
            entries = jar.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                className = name.substring(packageName.length() + 1, name.length() - 6);
                cname = String.valueOf(packageName) + '.' + className;
                try {
                    classes.add(Class.forName(cname));
                }
                catch (ClassNotFoundException e) {
                    ClassUtil._Logger.warn("\u5ffd\u7565\u52a0\u8f7d\u7c7b\u5f02\u5e38", (Throwable)e);
                }
            }
lbl47:
            // 6 sources

        } while (dirs.hasMoreElements());
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] fileArray = dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        int n = dirfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ClassUtil.findAndAddClassesInPackageByFile(String.valueOf(packageName) + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
            } else {
                String className = file.getName().substring(0, file.getName().length() - 6);
                try {
                    classes.add(Class.forName(String.valueOf(packageName) + '.' + className));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static Class<?> find(Type type, int index) {
        if (type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            if (types != null && types.length > index) {
                Type t = types[index];
                if (t instanceof Class) {
                    return (Class)t;
                }
                return ClassUtil.find(t, index);
            }
            return null;
        }
        return null;
    }

    public static final String getSimpleName(Class<?> clazz) {
        Map<Class<?>, String> cache = _SimpleNameCache;
        String name = cache.get(clazz);
        if (name == null) {
            name = clazz.getSimpleName();
            cache = new HashMap(cache);
            cache.put(clazz, name);
            _SimpleNameCache = cache;
        }
        return name;
    }

    public static Class<?> find(Class<?> clazz, Class<?> parameterizedSuperclass, String typeParamName) {
        Class<?> thisClass;
        Class<?> currentClass = thisClass = clazz;
        while (currentClass != null) {
            Class<?> result;
            if (currentClass.getSuperclass() == parameterizedSuperclass && (result = ClassUtil.dofind(currentClass.getSuperclass(), currentClass.getGenericSuperclass(), typeParamName)) != null) {
                return null;
            }
            Class<?>[] interfaces = currentClass.getInterfaces();
            Type[] interfaceTypes = currentClass.getGenericInterfaces();
            int i = 0;
            while (i < Math.min(interfaces.length, interfaceTypes.length)) {
                Class<?> result2;
                Class<?> myclazz = interfaces[i];
                if (myclazz == parameterizedSuperclass) {
                    Type mygeneric = interfaceTypes[i];
                    result2 = ClassUtil.dofind(myclazz, mygeneric, typeParamName);
                } else {
                    result2 = ClassUtil.find(myclazz, parameterizedSuperclass, typeParamName);
                }
                if (result2 != null) {
                    return result2;
                }
                ++i;
            }
            currentClass = currentClass.getSuperclass();
        }
        return null;
    }

    private static Class<?> dofind(Class<?> clazz, Type type, String typeParamName) {
        int typeParamIndex = -1;
        TypeVariable<Class<?>>[] typeParams = clazz.getTypeParameters();
        int i = 0;
        while (i < typeParams.length) {
            if (typeParamName.equals(typeParams[i].getName())) {
                typeParamIndex = i;
                break;
            }
            ++i;
        }
        if (typeParamIndex < 0) {
            return null;
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type[] actualTypeParams = ((ParameterizedType)type).getActualTypeArguments();
        Type actualTypeParam = actualTypeParams[typeParamIndex];
        if (actualTypeParam instanceof ParameterizedType) {
            actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
        }
        if (actualTypeParam instanceof Class) {
            return (Class)actualTypeParam;
        }
        if (actualTypeParam instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
            if (componentType instanceof ParameterizedType) {
                componentType = ((ParameterizedType)componentType).getRawType();
            }
            if (componentType instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
        }
        return null;
    }
}

