/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.DestroyableExt;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.execption.AbortException;
import cn.weforward.common.execption.OverflowException;
import cn.weforward.common.sys.ClockTick;
import cn.weforward.common.sys.StackTracer;
import cn.weforward.common.util.SinglyLinked;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayRunner<E>
implements DestroyableExt {
    public static final Logger _Logger = LoggerFactory.getLogger(DelayRunner.class);
    public static final boolean _DebugEnabled = _Logger.isDebugEnabled();
    public static final boolean _TraceEnabled = _Logger.isTraceEnabled();
    public static final boolean _InfoEnabled = _Logger.isInfoEnabled();
    protected static final int STATE_CLOSED = 4096;
    protected static final int STATE_STOP = 256;
    protected static final int STATE_READY = 16;
    protected static final int STATE_RESTART = 8192;
    protected static final int STATE_QUEUE_CHANGED = 16384;
    protected static final ClockTick _Tick = ClockTick.getInstance(1);
    protected final SinglyLinked<E> m_Tasks;
    protected final ReentrantLock m_Lock = new ReentrantLock();
    protected final Condition m_WaitForTask = this.m_Lock.newCondition();
    protected int m_Interval;
    protected int m_MaxSuspend;
    protected Thread m_Thread;
    protected volatile int m_State;
    protected int m_LastExecute;
    protected volatile int m_Completes;
    protected volatile int m_Pending;
    protected volatile SinglyLinked.Node<E> m_PendingTask;
    protected volatile int m_Fails;
    protected volatile int m_Total;
    protected String m_Name;

    protected abstract void execute(E var1) throws Exception;

    protected void onInit() {
    }

    protected void onFinally() {
    }

    protected void onBegin(int size) {
    }

    protected void onEnd() {
    }

    protected void onEnd(int completes, int count) {
        this.onEnd();
        this.m_State |= 0x4000;
    }

    protected void cleanQueue() {
        this.m_State &= 0xFFFFBFFF;
    }

    protected boolean onFail(SinglyLinked.Node<E> chain, Throwable e) {
        _Logger.error("\u5ffd\u7565\u5f02\u5e38\u7ee7\u7eed[" + chain.value + "]" + this, e);
        return true;
    }

    protected SinglyLinked<E> createTasks() {
        return new SinglyLinked();
    }

    public DelayRunner() {
        this(1);
    }

    public DelayRunner(int interval) {
        this("", interval);
    }

    public DelayRunner(String name, int interval) {
        this.m_Name = name;
        this.m_Interval = interval;
        this.m_Tasks = this.createTasks();
    }

    public void setInterval(int seconds) {
        this.m_Interval = seconds;
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public void setMaxSuspend(int limit) {
        this.m_MaxSuspend = limit;
    }

    public int getMaxSuspend() {
        return this.m_MaxSuspend;
    }

    public int getCompletes() {
        return this.m_Completes;
    }

    public int getPending() {
        return this.m_Pending;
    }

    public int getFails() {
        return this.m_Fails;
    }

    public int getTotal() {
        return this.m_Total;
    }

    public boolean submit(E task) {
        return this.submit(task, false);
    }

    public boolean submit(E task, boolean absent) {
        return this.submitInternal(task, absent) != null;
    }

    public Iterator<E> getQueueTasks() {
        return new SinglyLinked.LinkedIterator<E>(this.m_Tasks.getHead());
    }

    public Iterator<E> getPendingTasks() {
        SinglyLinked.Node<E> node = this.m_PendingTask;
        if (node == null) {
            List ls = Collections.emptyList();
            return ls.iterator();
        }
        return new SinglyLinked.LinkedIterator<E>(node);
    }

    protected int addAll(Iterator<E> it) {
        int count = this.m_Tasks.size();
        this.m_Lock.lock();
        try {
            int i = 0;
            while (it.hasNext() && i < 1000000) {
                E t = it.next();
                if (t != null) {
                    this.m_Tasks.addTail(t);
                }
                ++i;
            }
            this.m_State |= 0x4000;
        }
        finally {
            this.m_Lock.unlock();
        }
        count = this.m_Tasks.size() - count;
        if (it.hasNext()) {
            throw new OverflowException("\u8981\u52a0\u5165\u7684\u4efb\u52a1\u592a\u591a\uff08>" + count + "\uff09");
        }
        return count;
    }

    public SinglyLinked.Node<E> submitInternal(E task, boolean absent) {
        this.m_Lock.lock();
        try {
            SinglyLinked.Node<E> ret;
            if (!this.startThread(0)) {
                StringBuilder sb = new StringBuilder(128);
                sb.append("\u5df2\u5173\u95ed\uff0c\u5ffd\u7565\u6b64\u9879[").append(task).append("]");
                this.toString(sb).append('\n');
                _Logger.warn(StackTracer.printStackTrace(Thread.currentThread(), (Appendable)sb).toString());
                return null;
            }
            if (absent) {
                ret = this.m_Tasks.find(task);
                if (ret != null) {
                    SinglyLinked.Node<E> node = ret;
                    return node;
                }
                ret = this.m_Tasks.addTail(task);
            } else {
                ret = this.m_Tasks.addTail(task);
            }
            this.m_State |= 0x4000;
            if (this.m_LastExecute == 0) {
                this.m_LastExecute = _Tick.getTicker();
            }
            if (this.m_Tasks.size() > 1 && !this.condition()) {
                SinglyLinked.Node<E> node = ret;
                return node;
            }
            this.m_WaitForTask.signal();
            SinglyLinked.Node<E> node = ret;
            return node;
        }
        finally {
            this.m_Lock.unlock();
        }
    }

    private boolean condition() {
        if (this.m_MaxSuspend > 0 && this.m_Tasks.size() >= this.m_MaxSuspend) {
            return true;
        }
        return this.m_Interval == 0 || _Tick.getTicker() >= this.m_Interval + this.m_LastExecute;
    }

    public boolean isStop() {
        return DelayRunner.isStop(this.m_State);
    }

    private static boolean isStop(int state) {
        return 4096 == (0x1000 & state) || 256 == (0x100 & state);
    }

    public boolean isQueueChanged() {
        return 16384 == (this.m_State & 0x4000);
    }

    private boolean startThread(final int delay) {
        if (this.isStop()) {
            return false;
        }
        if (16 == (0x10 & this.m_State)) {
            return true;
        }
        Thread thread = this.m_Thread;
        if (thread != null && thread.isAlive()) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("\u7ebf\u7a0b\u5de5\u4f5c\u4e2d\uff0c\u4f46\u4e0e\u72b6\u6001\u4e0d\u76f8\u914d");
            this.toString(sb).append('\n');
            _Logger.error(StackTracer.printStackTrace(thread, (Appendable)sb).toString());
            return true;
        }
        thread = new Thread(){

            @Override
            public void run() {
                if (delay > 0) {
                    try {
                        1.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (StringUtil.isEmpty(DelayRunner.this.m_Name)) {
                    this.setName("DR-" + Hex.toHex(DelayRunner.this.hashCode()) + "-" + Hex.toHex(this.hashCode()));
                } else {
                    this.setName("DR-" + DelayRunner.this.m_Name);
                }
                DelayRunner.this.m_Thread = this;
                DelayRunner.this.m_Fails = 0;
                try {
                    DelayRunner.this.daemon();
                }
                catch (Throwable throwable) {
                    boolean restart = 8192 == (0x2000 & DelayRunner.this.m_State);
                    DelayRunner.this.m_Lock.lock();
                    try {
                        DelayRunner.this.m_Thread = null;
                        if (restart) {
                            DelayRunner.this.m_State &= 0xFFFFCEEF;
                            DelayRunner.this.startThread(0);
                        } else {
                            DelayRunner.this.m_State |= 0x1000;
                        }
                    }
                    finally {
                        DelayRunner.this.m_Lock.unlock();
                    }
                    if (restart) {
                        _Logger.warn("\u91cd\u542f\u4efb\u52a1\u7ebf\u7a0b [" + this + "]" + DelayRunner.this);
                    }
                    throw throwable;
                }
                boolean restart = 8192 == (0x2000 & DelayRunner.this.m_State);
                DelayRunner.this.m_Lock.lock();
                try {
                    DelayRunner.this.m_Thread = null;
                    if (restart) {
                        DelayRunner.this.m_State &= 0xFFFFCEEF;
                        DelayRunner.this.startThread(0);
                    } else {
                        DelayRunner.this.m_State |= 0x1000;
                    }
                }
                finally {
                    DelayRunner.this.m_Lock.unlock();
                }
                if (restart) {
                    _Logger.warn("\u91cd\u542f\u4efb\u52a1\u7ebf\u7a0b [" + this + "]" + DelayRunner.this);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.m_State |= 0x10;
        return true;
    }

    public void start() {
        this.start(0);
    }

    public void start(int delay) {
        this.m_Lock.lock();
        try {
            if (this.isStop()) {
                this.m_State &= 0xFFFFCEEF;
                _Logger.info("\u5df2\u91cd\u7f6e\u505c\u6b62\u72b6\u6001\uff1a" + this);
            }
        }
        finally {
            this.m_Lock.unlock();
        }
        this.startThread(delay);
    }

    public void stop() {
        Thread thread;
        this.m_Lock.lock();
        try {
            thread = this.m_Thread;
            if (4096 == (0x1000 & this.m_State) || thread == null || !thread.isAlive()) {
                return;
            }
            this.m_State |= 0x100;
            this.m_WaitForTask.signal();
        }
        finally {
            this.m_Lock.unlock();
        }
        try {
            thread.join(30000L);
        }
        catch (InterruptedException e) {
            _Logger.warn(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void restart() {
        this.m_Lock.lock();
        try {
            Thread thread = this.m_Thread;
            if (4096 != (0x1000 & this.m_State) && thread != null && thread.isAlive()) {
                this.m_State |= 0x2100;
                this.m_WaitForTask.signal();
                return;
            }
            this.startThread(0);
        }
        finally {
            this.m_Lock.unlock();
        }
    }

    protected void execute(SinglyLinked.Node<E> task) throws Exception {
        this.execute(task.value);
    }

    public void executeTasks() {
        SinglyLinked.SinglyLinkedNode first;
        int count;
        this.m_Lock.lock();
        try {
            count = this.m_Pending = this.m_Tasks.size();
            first = this.m_Tasks.detach();
            if (first == null) {
                return;
            }
        }
        finally {
            this.m_Lock.unlock();
        }
        if (_TraceEnabled) {
            _Logger.trace("DelayRunning...");
        }
        this.m_PendingTask = first;
        this.onBegin(count);
        int completes = 0;
        while (first != null) {
            block15: {
                int state = this.m_State;
                if (8192 == (0x2000 & state) && DelayRunner.isStop(state)) {
                    this.m_Lock.lock();
                    try {
                        this.m_Tasks.attachToHead((SinglyLinked.Node<E>)first);
                    }
                    finally {
                        this.m_Lock.unlock();
                    }
                    if (!_TraceEnabled) break;
                    _Logger.trace("put to chain on restart.");
                    break;
                }
                try {
                    --this.m_Pending;
                    ++this.m_Total;
                    this.execute((SinglyLinked.Node<E>)first);
                    ++completes;
                    ++this.m_Completes;
                    this.m_Fails = 0;
                }
                catch (Throwable e) {
                    ++this.m_Fails;
                    if (this.isStop() && e instanceof AbortException) {
                        _Logger.error("\u5df2\u505c\u6b62\u72b6\u6001\u4e0b\u4e2d\u6b62\u4e4b\u540e\u6240\u6709\u7684\u4efb\u52a1\u6267\u884c[" + first.value + "]" + this, e);
                        break;
                    }
                    if (this.onFail((SinglyLinked.Node<E>)first, e)) break block15;
                    _Logger.error("\u5f02\u5e38\u4e14\u7ed3\u675f\u4efb\u52a1\u961f\u5217[" + first.value + "]" + this, e);
                    break;
                }
            }
            first = first.getNext();
        }
        this.m_PendingTask = null;
        this.m_Pending = 0;
        this.onEnd(completes, count);
        this.m_LastExecute = _Tick.getTicker();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void daemon() {
        DelayRunner._Logger.info("beginning [" + this.m_Thread + "]");
        this.onInit();
        block7: do {
            this.m_Lock.lock();
            try {
            }
            catch (Throwable var3_4) {
                this.m_Lock.unlock();
                throw var3_4;
            }
            {
                ** while (256 != (256 & this.m_State))
            }
lbl-1000:
            // 1 sources

            {
                if (this.m_MaxSuspend > 0 && this.m_Tasks.size() >= this.m_MaxSuspend) {
                    if (!DelayRunner._Logger.isInfoEnabled()) break;
                    DelayRunner._Logger.info("Over suspends: " + this.m_MaxSuspend + "/" + this.m_Tasks.size());
                    break;
                }
                interval = 0;
                if (!this.m_Tasks.isEmpty()) {
                    if (this.m_Interval == 0) break;
                    interval = DelayRunner._Tick.getTicker() - this.m_LastExecute;
                    if (interval >= this.m_Interval) {
                        if (!DelayRunner._DebugEnabled) break;
                        DelayRunner._Logger.debug("DelayFlush signal." + interval);
                        break;
                    }
                    interval = this.m_Interval - interval;
                }
                if (DelayRunner._DebugEnabled) {
                    DelayRunner._Logger.debug("Waiting... " + interval);
                }
                try {
                    if (interval < 1) {
                        this.m_WaitForTask.await();
                        continue;
                    }
                    this.m_WaitForTask.await(interval, TimeUnit.SECONDS);
                    continue;
                }
                catch (InterruptedException e) {
                    DelayRunner._Logger.warn(this.toString(new StringBuilder("\u6267\u884c\u5668\u88ab\u4e2d\u65ad")).toString());
                    this.m_Lock.unlock();
                    break block7;
                }
            }
lbl37:
            // 6 sources

            this.m_Lock.unlock();
            try {
                this.executeTasks();
            }
            catch (Throwable e) {
                DelayRunner._Logger.error("\u6267\u884c\u4efb\u52a1\u5f02\u5e38\uff1a" + this, e);
            }
        } while (256 != (256 & this.m_State));
        this.onFinally();
        DelayRunner._Logger.info("end [" + this.m_Thread + "]");
    }

    @Override
    public boolean destroySignal() {
        this.m_Lock.lock();
        try {
            if (!this.m_Tasks.isEmpty()) {
                this.m_LastExecute = _Tick.getTicker() - (1 + this.m_Interval);
                this.m_WaitForTask.signal();
            }
        }
        finally {
            this.m_Lock.unlock();
        }
        Thread thread = this.m_Thread;
        if (thread != null) {
            try {
                thread.interrupt();
            }
            catch (Throwable throwable) {}
        } else if (this.isStop()) {
            return false;
        }
        if (!this.m_Tasks.isEmpty() || this.m_PendingTask != null) {
            _Logger.info(this.toString());
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.stop();
    }

    protected void complete() {
        while (!this.m_Tasks.isEmpty()) {
            this.executeTasks();
        }
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("{name:").append(this.m_Name).append(",state:").append(this.m_State).append(",queue:").append(this.m_Tasks.size()).append(",pending:").append(this.getPending()).append(",complete:").append(this.getCompletes()).append(",fails:").append(this.getFails()).append(",total:").append(this.getTotal()).append(",interval:").append(this.m_Interval).append(",max:").append(this.m_MaxSuspend).append(",thread:").append(this.m_Thread).append("}");
        return sb;
    }
}

