/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class FreezedList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final E[] m_Elements;
    protected final int m_Size;
    protected final int m_Offset;
    public static final Object[] _nilArray = new Object[0];
    public static final Comparator<String> _compString = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null || o1.length() == 0) {
                return 1;
            }
            if (o2 == null || o2.length() == 0) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };

    public static <E> List<E> freezed(List<E> list) {
        if (list instanceof FreezedList) {
            return list;
        }
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return new FreezedList<E>(list);
    }

    public static <E> List<E> freezed(List<E> list, boolean trimNull) {
        if (list instanceof FreezedList) {
            return list;
        }
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            E element = list.get(0);
            if (element == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(element);
        }
        return new FreezedList<E>(list, trimNull);
    }

    public static <E> List<E> replaceToFreezed(List<? extends E> list, int index, E value) {
        if (index < 0 || index >= list.size()) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " over 0~" + list.size());
        }
        if (1 == list.size()) {
            return Collections.singletonList(value);
        }
        Object[] elements = list.toArray();
        elements[index] = value;
        return new FreezedList<Object>(elements, elements.length, true);
    }

    public static <E> List<E> removeToFreezed(List<? extends E> list, int index, int count) {
        if (index < 0 || count < 0 || index + count > list.size()) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + "/" + count + " over 0~" + list.size());
        }
        if (index == 0 && list.size() == count) {
            return Collections.emptyList();
        }
        Object[] elements = new Object[list.size() - count];
        int i = 0;
        while (i < index) {
            elements[i] = list.get(i);
            ++i;
        }
        index += count;
        while (index < list.size()) {
            elements[i++] = list.get(index);
            ++index;
        }
        return new FreezedList<Object>(elements, elements.length, true);
    }

    public static <E> List<E> addToFreezed(List<? extends E> list, int index, E value) {
        if (index < 0 || index > list.size()) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " over 0~" + list.size());
        }
        if (list.size() == 0) {
            return Collections.singletonList(value);
        }
        Object[] elements = new Object[list.size() + 1];
        int i = 0;
        while (i < index) {
            elements[i] = list.get(i);
            ++i;
        }
        elements[index++] = value;
        while (i < list.size()) {
            elements[index++] = list.get(i);
            ++i;
        }
        return new FreezedList<Object>(elements, elements.length, true);
    }

    public static <E> List<E> freezed(Collection<E> coll) {
        if (coll instanceof FreezedList) {
            return (List)coll;
        }
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        if (coll.size() == 1) {
            Object[] a = coll.toArray(new Object[1]);
            return Collections.singletonList(a[0]);
        }
        return new FreezedList<E>(coll);
    }

    public static <E> List<E> freezed(Collection<E> coll, Comparator<? super E> sort) {
        if (sort == null) {
            return FreezedList.freezed(coll);
        }
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        if (coll.size() == 1) {
            Object[] a = coll.toArray(new Object[1]);
            return Collections.singletonList(a[0]);
        }
        Object[] elements = coll.toArray();
        Arrays.sort(elements, sort);
        return new FreezedList<Object>(elements, elements.length, true);
    }

    public static <E> List<E> freezed(E[] elements, Comparator<? super E> sort) {
        if (elements.length == 0) {
            return Collections.emptyList();
        }
        if (1 == elements.length) {
            return Collections.singletonList(elements[0]);
        }
        elements = Arrays.copyOf(elements, elements.length);
        if (sort != null) {
            Arrays.sort(elements, sort);
        }
        return new FreezedList<E>(elements, elements.length, true);
    }

    public static List<String> freezedStrings(List<String> list) {
        if (list instanceof StringList) {
            return list;
        }
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        String[] elements = (String[])list.toArray();
        Arrays.sort(elements, _compString);
        int i = elements.length - 1;
        while (i >= 0) {
            if (elements[i] != null && elements[i].length() != 0) break;
            --i;
        }
        if (i < 0) {
            return Collections.emptyList();
        }
        return new StringList(elements, 0, i + 1);
    }

    public FreezedList(E[] elements, int size, boolean attach) {
        this(elements, 0, size, attach);
    }

    public FreezedList(E[] elements, int offset, int size, boolean isAttach) {
        this.m_Size = size;
        if (isAttach) {
            this.m_Elements = elements;
            this.m_Offset = offset;
        } else {
            this.m_Elements = new Object[this.m_Size];
            System.arraycopy(elements, offset, this.m_Elements, 0, this.m_Size);
            this.m_Offset = 0;
        }
    }

    protected FreezedList(E[] elements) {
        this.m_Elements = elements;
        this.m_Size = elements == null ? 0 : elements.length;
        this.m_Offset = 0;
    }

    public FreezedList(Collection<? extends E> elements) {
        this(elements, false);
    }

    public FreezedList(Collection<? extends E> elements, boolean trimNull) {
        if (trimNull) {
            Object[] ls = new Object[elements.size()];
            Iterator<E> it = elements.iterator();
            int count = 0;
            while (it.hasNext()) {
                E o = it.next();
                if (o == null) continue;
                ls[count++] = o;
            }
            if (count + 4 <= ls.length) {
                ls = Arrays.copyOf(ls, count);
            }
            this.m_Elements = ls;
            this.m_Size = count;
        } else {
            Object[] ls = elements.toArray();
            this.m_Elements = ls;
            this.m_Size = this.m_Elements.length;
        }
        this.m_Offset = 0;
    }

    @Override
    public E get(int index) {
        return this.m_Elements[index + this.m_Offset];
    }

    @Override
    public int size() {
        return this.m_Size;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.m_Elements);
        return result;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return Collections.emptyList();
        }
        return new FreezedList<E>(this.m_Elements, fromIndex + this.m_Offset, toIndex - fromIndex, true);
    }

    @Override
    public Object[] toArray() {
        if (this.size() == 0) {
            return _nilArray;
        }
        Object[] array = new Object[this.size()];
        System.arraycopy(this.m_Elements, this.m_Offset, array, 0, array.length);
        return array;
    }

    public static class StringList
    extends FreezedList<String> {
        private static final long serialVersionUID = 1L;

        protected StringList(String[] elements, int offset, int size) {
            super(elements, offset, size, true);
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            String s = o.toString();
            int i = this.size();
            if (s.length() == 0 || i < 1) {
                return false;
            }
            if (i > 1000) {
                int ret = Arrays.binarySearch((String[])this.m_Elements, this.m_Offset, this.m_Offset + this.size(), s, _compString);
                return ret >= 0;
            }
            --i;
            while (i >= 0) {
                int ret = s.compareTo((String)this.get(i));
                if (ret == 0) {
                    return true;
                }
                if (ret > 0) {
                    return false;
                }
                --i;
            }
            return false;
        }
    }
}

