/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.crypto.Hex;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IpRanges {
    protected List<Range> m_RangeList = Collections.emptyList();

    public IpRanges() {
    }

    public IpRanges(String ipList) {
        if (StringUtil.isEmpty(ipList)) {
            return;
        }
        String[] ss = ipList.split("\\;");
        if (ss.length > 0) {
            ArrayList<Range> ls = new ArrayList<Range>(ss.length);
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!StringUtil.isEmpty(s)) {
                    ls.add(new Range(s));
                }
                ++n2;
            }
            this.m_RangeList = ls;
        }
    }

    public Range find(String address) {
        return this.find(IpRanges.ipv4(address));
    }

    public Range find(byte[] address) {
        int ip = IpRanges.ipv4(address);
        if (ip == 0) {
            return null;
        }
        return this.find(ip);
    }

    public Range find(int ip) {
        for (Range ipr : this.m_RangeList) {
            if (!ipr.match(ip)) continue;
            return ipr;
        }
        return null;
    }

    public void set(List<String> ipList) {
        this.m_RangeList = new ArrayList<Range>(ipList.size());
        for (String s : ipList) {
            this.m_RangeList.add(new Range(s));
        }
    }

    public static int ipv4(byte[] addr) {
        if (addr == null || addr.length != 4) {
            return 0;
        }
        int ip = addr[3] & 0xFF;
        ip |= addr[2] << 8 & 0xFF00;
        ip |= addr[1] << 16 & 0xFF0000;
        return ip |= addr[0] << 24 & 0xFF000000;
    }

    public static int ipv4(String ip) {
        int v4 = 0;
        int begin = 0;
        int idx = ip.indexOf(46, begin);
        if (-1 == idx) {
            return 0;
        }
        v4 = NumberUtil.toInt(ip.substring(begin, idx)) << 24;
        begin = idx + 1;
        if (-1 == (idx = ip.indexOf(46, begin))) {
            return 0;
        }
        v4 |= NumberUtil.toInt(ip.substring(begin, idx)) << 16;
        begin = idx + 1;
        if (-1 == (idx = ip.indexOf(46, begin))) {
            return 0;
        }
        v4 |= NumberUtil.toInt(ip.substring(begin, idx)) << 8;
        return v4 |= NumberUtil.toInt(ip.substring(idx + 1));
    }

    public static class Range {
        public final int start;
        public final int end;

        public Range(String ips) {
            int idx = ips.indexOf(45);
            if (-1 == idx) {
                this.end = this.start = IpRanges.ipv4(ips);
            } else {
                this.start = IpRanges.ipv4(ips.substring(0, idx));
                this.end = IpRanges.ipv4(ips.substring(idx + 1));
            }
        }

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean match(int ip) {
            if (this.end < 0 && this.start >= 0) {
                if (ip >= 0) {
                    return ip >= this.start;
                }
                return ip <= this.end;
            }
            return ip >= this.start && ip <= this.end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return "{s:" + Hex.toHex32(this.start) + ",e:" + Hex.toHex32(this.end) + "}";
        }
    }
}

