/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.sys.StackTracer;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedPool<E> {
    public static final int STATE_IDLE = 0;
    public static final int STATE_INUSE = 1;
    public static final int STATE_EMPTY = 2;
    public static final int STATE_OLD = 3;
    public static final int STATE_DELAY = 10;
    public static final int STATE_LONGTIME = 20;
    protected static final Logger _Logger = LoggerFactory.getLogger(LinkedPool.class);
    protected static final Timer _Timer = new Timer("LinkedPool-Timer", true);
    protected int m_QueueTimeout;
    protected int m_QueueLengthMax;
    protected int m_MaxSize;
    protected Element<E> m_ResourceChain;
    protected Element<E> m_InUseChain;
    protected int m_InUseCount;
    protected final AtomicInteger m_InQueue = new AtomicInteger();
    protected final String m_Name;
    protected volatile int m_CreateTimes;
    protected IdleChecker m_IdleChecker;
    protected LongtimeChecker m_LongtimeChecker;

    public LinkedPool(int maxSize, String name) {
        this.m_Name = name == null ? "" : name;
        this.m_QueueTimeout = 0;
        this.m_MaxSize = maxSize;
        this.m_QueueLengthMax = maxSize;
    }

    public String getName() {
        return this.m_Name;
    }

    public synchronized void close() {
        this.abort();
        Element n = this.m_ResourceChain;
        while (n != null) {
            this.onCloseElement(n);
            n = n.next;
        }
        this.m_ResourceChain = null;
    }

    public synchronized int abort() {
        Element n = this.m_InUseChain;
        while (n != null) {
            this.onCloseElement(n);
            n = n.next;
        }
        return this.getInUseCount();
    }

    public void shutdown() {
        this.m_QueueLengthMax = 0;
    }

    protected E onCreateElement() {
        return null;
    }

    protected void onCloseElement(Element<E> element) {
    }

    protected void onIdle(Element<E> element, int idle) {
        if (_Logger.isInfoEnabled()) {
            String msg;
            StringBuilder builder = StringBuilderPool._128.poll();
            try {
                builder.append("{n:").append(this.m_Name).append(",idle-ms:").append(idle).append("}");
                if (element != null) {
                    element.toString(builder, false);
                }
                msg = builder.toString();
            }
            finally {
                StringBuilderPool._128.offer(builder);
            }
            _Logger.info(msg);
        }
        element.state = 3;
    }

    protected void onLongtime(Element<E> element, int useup) {
        String msg;
        if (!_Logger.isWarnEnabled()) {
            return;
        }
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            builder.append("{n:").append(this.m_Name).append(",useup-ms:").append(useup).append("}");
            if (element != null) {
                element.toString(builder, true);
            }
            msg = builder.toString();
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
        _Logger.warn(msg);
    }

    public int getMaxSize() {
        return this.m_MaxSize;
    }

    public synchronized void setQueueLengthMax(int size) {
        if (size < this.getMaxSize()) {
            throw new IllegalArgumentException("size\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8emaxSize(" + this.getMaxSize() + "), \u4f46\u5b83=" + size);
        }
        this.m_QueueLengthMax = size;
    }

    public int getQueueLengthMax() {
        return this.m_QueueLengthMax;
    }

    public synchronized void setQueueTimeout(int mills) {
        if (mills < 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e0d\u5c0f\u4e8e0");
        }
        this.m_QueueTimeout = mills;
    }

    public int getQueueTimeout() {
        return this.m_QueueTimeout;
    }

    public synchronized void setIdle(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e0d\u5c0f\u4e8e0");
        }
        if (this.m_IdleChecker != null) {
            this.m_IdleChecker.cancel();
            this.m_IdleChecker = null;
        }
        if (seconds > 0) {
            this.m_IdleChecker = new IdleChecker(seconds);
        }
    }

    public int getIdle() {
        return this.m_IdleChecker == null ? 0 : this.m_IdleChecker.m_Idle;
    }

    public synchronized void setLongtime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e0d\u5c0f\u4e8e0");
        }
        if (this.m_LongtimeChecker != null && this.m_LongtimeChecker.getLongtime() == seconds) {
            return;
        }
        if (this.m_LongtimeChecker != null) {
            this.m_LongtimeChecker.cancel();
            this.m_LongtimeChecker = null;
        }
        if (seconds < 1) {
            return;
        }
        this.m_LongtimeChecker = new LongtimeChecker(seconds);
    }

    public int getLongtime() {
        return this.m_LongtimeChecker == null ? 0 : this.m_LongtimeChecker.m_Longtime;
    }

    public int getInQueue() {
        return this.m_InQueue.get();
    }

    public int getCreateTimes() {
        return this.m_CreateTimes;
    }

    public int getInUseCount() {
        return this.m_InUseCount;
    }

    /*
     * Exception decompiling
     */
    public E poll() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void offer(E resource) {
        this.offer(resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(E resource, boolean empty) {
        if (resource == null) {
            return;
        }
        Element processer = null;
        LinkedPool linkedPool = this;
        synchronized (linkedPool) {
            Element f;
            Element n = f = this.m_InUseChain;
            while (n != null) {
                if (resource == n.resource) {
                    if (n == this.m_InUseChain) {
                        this.m_InUseChain = n.next;
                    } else {
                        f.next = n.next;
                    }
                    processer = n;
                    processer.idle();
                    if (empty) {
                        processer.clear();
                    }
                    processer.next = (Element)this.m_ResourceChain;
                    this.m_ResourceChain = processer;
                    --this.m_InUseCount;
                    this.m_InQueue.decrementAndGet();
                    this.notify();
                    return;
                }
                f = n;
                n = n.next;
            }
        }
        _Logger.warn("offer mismatch:" + resource);
    }

    public synchronized Element<E> getUsing(E resource) {
        if (this.m_InUseChain == null) {
            return null;
        }
        Element n = this.m_InUseChain;
        while (n != null) {
            if (resource == n.resource) {
                return n;
            }
            n = n.next;
        }
        return null;
    }

    private synchronized void use(Element<E> element) {
        element.inUse();
        ((Element)element).next = (Element)this.m_InUseChain;
        this.m_InUseChain = element;
    }

    private synchronized void free(Element<E> element) {
        if (this.m_InUseChain == null) {
            return;
        }
        if (element == this.m_InUseChain) {
            this.m_InUseChain = ((Element)element).next;
            return;
        }
        Element n = this.m_InUseChain;
        while (n != null) {
            if (element == n.next) {
                n.next = ((Element)element).next;
                break;
            }
            n = n.next;
        }
    }

    public String toString() {
        return this.formatMessage(null);
    }

    private String formatMessage(String msg) {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            if (!StringUtil.isEmpty(msg)) {
                builder.append(msg);
            }
            builder.append("{");
            this.toString(builder);
            builder.append(",use:").append(this.getInUseCount());
            builder.append("}");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    public StringBuilder toString(StringBuilder builder) {
        builder.append("N:").append(this.getName()).append(",C:").append(this.getInUseCount()).append(",max:").append(this.getMaxSize()).append(",queue:").append(this.m_InQueue.get()).append(",QL:").append(this.m_QueueLengthMax).append(",QT:").append(this.m_QueueTimeout);
        if (this.m_CreateTimes > 0) {
            builder.append(",create:").append(this.getCreateTimes());
        }
        return builder;
    }

    public String dump() {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            builder.append("{");
            this.toString(builder);
            Element n = this.m_ResourceChain;
            if (n != null) {
                builder.append("res:[\n");
                while (n != null) {
                    if (n != this.m_ResourceChain) {
                        builder.append(",\n");
                    }
                    n.toString(builder, true);
                    n = n.next;
                }
                builder.append("\n]");
            }
            if ((n = this.m_InUseChain) != null) {
                builder.append(",use:[\n");
                while (n != null) {
                    if (n != this.m_InUseChain) {
                        builder.append(",\n");
                    }
                    n.toString(builder, true);
                    n = n.next;
                }
                builder.append("\n]");
            }
            builder.append("}");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    public static class Element<E> {
        private Element<E> next;
        private E resource;
        protected long startTime;
        protected int activitys;
        protected int times;
        protected long uptime;
        protected int state;
        protected Thread thread;

        protected synchronized void setResource(E resource) {
            this.resource = resource;
        }

        protected synchronized void inUse() {
            this.state = 1;
            this.startTime = System.currentTimeMillis();
            this.thread = Thread.currentThread();
            ++this.times;
        }

        protected synchronized void idle() {
            long now = System.currentTimeMillis();
            this.state = 0;
            if (now > this.startTime) {
                this.uptime += now - this.startTime;
            }
            this.thread = null;
            this.startTime = now;
            this.activitys = 0;
        }

        public synchronized int activity() {
            if (this.state == 0) {
                this.startTime = System.currentTimeMillis();
                ++this.activitys;
            }
            return this.activitys;
        }

        public synchronized void clear() {
            this.state = 2;
            this.resource = null;
            this.thread = null;
            if (_Logger.isDebugEnabled()) {
                _Logger.debug(this.formatMessage("clear "));
            }
        }

        public boolean isIdle() {
            return this.state == 0;
        }

        public boolean isEmpty() {
            return 2 == this.state;
        }

        public Element<E> getNext() {
            return this.next;
        }

        public int getActivitys() {
            return this.activitys;
        }

        public int getTimes() {
            return this.times;
        }

        public int getUseup() {
            if (0L == this.startTime) {
                return 0;
            }
            return (int)(System.currentTimeMillis() - this.startTime);
        }

        public Thread getThread() {
            return this.thread;
        }

        public E getResource() {
            return this.resource;
        }

        public int getState() {
            return this.state;
        }

        public String toString() {
            return this.formatMessage(null);
        }

        public String formatMessage(String msg) {
            StringBuilder builder = StringBuilderPool._128.poll();
            try {
                if (!StringUtil.isEmpty(msg)) {
                    builder.append(msg);
                }
                String string = this.toString(builder, false).toString();
                return string;
            }
            finally {
                StringBuilderPool._128.offer(builder);
            }
        }

        public StringBuilder toString(StringBuilder builder, boolean trace) {
            builder.append("{s:");
            if (1 == this.state) {
                builder.append("inuse");
            } else if (this.state == 0) {
                builder.append("idle");
            } else if (2 == this.state) {
                builder.append("empty");
            } else if (10 == this.state) {
                builder.append("delay");
            } else if (20 == this.state) {
                builder.append("longtime");
            } else if (3 == this.state) {
                builder.append("old");
            } else {
                builder.append(this.state);
            }
            if (this.times > 0) {
                builder.append(",times:").append(this.times);
            }
            if (this.uptime > 10000L) {
                builder.append(",uptime(s):").append(this.uptime / 1000L);
            } else if (this.uptime > 0L) {
                builder.append(",uptime:").append(this.uptime);
            }
            if (this.activitys > 0) {
                builder.append(",activitys:").append(this.activitys);
            }
            if (1 == this.state) {
                int useup = this.getUseup();
                if (useup > 10000) {
                    builder.append(",useup(s):").append(useup / 1000);
                } else {
                    builder.append(",useup:").append(useup);
                }
            }
            if (this.resource != null) {
                builder.append(",res:").append(this.resource);
            }
            if (this.thread != null && !trace) {
                builder.append(",thread:").append(this.thread);
            }
            builder.append("}");
            if (trace && this.thread != null) {
                builder.append('\n');
                StackTracer.printStackTrace(this.thread, (Appendable)builder);
            }
            return builder;
        }
    }

    class IdleChecker
    extends TimerTask {
        int m_Idle;

        IdleChecker(int seconds) {
            this.m_Idle = seconds;
            long t = 1000L * (long)seconds / 5L;
            if (t < 1000L) {
                t = 1000L;
            }
            _Timer.schedule((TimerTask)this, t, t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Element f = LinkedPool.this.m_ResourceChain;
            if (f == null) {
                return;
            }
            int idel = this.m_Idle * 1000;
            LinkedPool linkedPool = LinkedPool.this;
            synchronized (linkedPool) {
                long now = System.currentTimeMillis();
                Element n = f;
                while (n != null) {
                    int interval;
                    if (n.isEmpty()) {
                        if (n == LinkedPool.this.m_ResourceChain) {
                            LinkedPool.this.m_ResourceChain = n.next;
                        } else {
                            f.next = n.next;
                        }
                    } else if (n.startTime > 0L && n.isIdle() && (interval = (int)(now - n.startTime)) >= idel) {
                        try {
                            LinkedPool.this.onIdle(n, interval);
                        }
                        catch (Throwable e) {
                            _Logger.error(String.valueOf(n), e);
                        }
                    }
                    f = n;
                    n = n.next;
                }
            }
        }
    }

    class LongtimeChecker
    extends TimerTask {
        int m_Longtime;

        LongtimeChecker(int seconds) {
            this.m_Longtime = seconds;
            long t = 1000L * (long)seconds / 5L;
            if (t < 1000L) {
                t = 1000L;
            }
            _Timer.schedule((TimerTask)this, t, t);
        }

        public int getLongtime() {
            return this.m_Longtime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Element f = LinkedPool.this.m_InUseChain;
            if (f == null) {
                return;
            }
            int timeout = this.m_Longtime * 1000;
            LinkedPool linkedPool = LinkedPool.this;
            synchronized (linkedPool) {
                long now = System.currentTimeMillis();
                Element n = f;
                while (n != null) {
                    if (n.startTime > 0L && n.state < 20) {
                        int interval = (int)(now - n.startTime);
                        try {
                            if (interval > timeout) {
                                n.state = 20;
                                LinkedPool.this.onLongtime(n, interval);
                            }
                        }
                        catch (Throwable e) {
                            _Logger.error(String.valueOf(n), e);
                        }
                    }
                    f = n;
                    n = n.next;
                }
            }
        }
    }
}

