/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.ResultPage;
import cn.weforward.common.util.ComparatorExt;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ListUtil {
    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static <E> List<E> reverse(List<E> list) {
        if (list.size() < 2) {
            return list;
        }
        return new ReverseList<E>(list);
    }

    public static <E> List<E> toList(List<E> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static <E> List<E> toList(ResultPage<E> rp) {
        if (rp.getCount() == 0) {
            return Collections.emptyList();
        }
        if (1 == rp.getCount()) {
            rp.gotoPage(1);
            return Collections.singletonList(rp.next());
        }
        return new ResultPageList<E>(rp);
    }

    public static <E> void add(List<E> list, E obj) {
        if (!list.contains(obj)) {
            list.add(obj);
        }
    }

    public static <E> void addAll(List<E> list1, List<E> list2) {
        for (E obj : list2) {
            if (list1.contains(obj)) continue;
            list1.add(obj);
        }
    }

    public static <T> List<T> fill(T obj, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        if (1 == count) {
            return Collections.singletonList(obj);
        }
        Object[] objs = new Object[count];
        Arrays.fill(objs, obj);
        return Arrays.asList(objs);
    }

    public static int indexOf(int[] arr, int val) {
        if (arr == null || arr.length == 0) {
            return -1;
        }
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(int[] arr, int val) {
        return -1 != ListUtil.indexOf(arr, val);
    }

    public static <E> List<E> union(final List<List<E>> lists) {
        int size = 0;
        for (List<E> list : lists) {
            size += list.size();
        }
        final int _s = size;
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                int i = 0;
                while (i < lists.size()) {
                    if (index < ((List)lists.get(i)).size()) break;
                    index -= ((List)lists.get(i)).size();
                    ++i;
                }
                return ((List)lists.get(i)).get(index);
            }

            @Override
            public int size() {
                return _s;
            }
        };
    }

    public static <E> List<E> union(List<E> ... lists) {
        return ListUtil.union(Arrays.asList(lists));
    }

    public static boolean eq(List<?> l1, List<?> l2) {
        return l1 == l2 || ListUtil.isEmpty(l1) && ListUtil.isEmpty(l2) || l1 != null && l1.equals(l2);
    }

    public static <E, K> int binarySearch(List<? extends E> list, K key, ComparatorExt<? super E, K> c) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            E midVal = list.get(mid);
            int cmp = c.compareTo(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static class ResultPageList<E>
    extends AbstractList<E> {
        ResultPage<E> m_Original;

        ResultPageList(ResultPage<E> rp) {
            this.m_Original = rp;
        }

        @Override
        public E get(int index) {
            int pageSize = this.m_Original.getPageSize();
            int page = index / pageSize + 1;
            int pos = index % pageSize;
            if (this.m_Original.getPage() != page) {
                this.m_Original.gotoPage(page);
            }
            return this.m_Original.move(pos);
        }

        @Override
        public int size() {
            return this.m_Original.getCount();
        }
    }

    private static class ReverseList<E>
    extends AbstractList<E> {
        List<E> m_Orginal;

        ReverseList(List<E> list) {
            this.m_Orginal = list;
        }

        @Override
        public E get(int index) {
            return this.m_Orginal.get(this.m_Orginal.size() - index - 1);
        }

        @Override
        public int size() {
            return this.m_Orginal.size();
        }
    }
}

