/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.execption.AbortException;
import cn.weforward.common.execption.OverloadException;
import cn.weforward.common.execption.TimeoutException;
import cn.weforward.common.sys.ClockTick;
import cn.weforward.common.util.LruHashMap;
import cn.weforward.common.util.SinglyLinkedLifo;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public class LruCache<K, V>
extends LruHashMap<K, V> {
    public static final int POLICY_GC_FORWARD = 4096;
    public static final int OPTION_REACHABLE = 0x20000000;
    protected static final ClockTick _clock = ClockTick.getInstance(1);
    protected static final WeakReference<?> _pending = new MarkReference("pending");
    protected static final WeakReference<?> _unassigned = new MarkReference("unassigned");
    protected static final WeakReference<?> _dirty = new MarkReference("dirty");
    protected static final DirtyData<?> _emptyDirtyData = new EmptyDirtyData();
    protected String m_Name;
    protected int m_Options;
    protected int m_Timeout = 600;
    protected int m_NullTimeout = 0;
    protected int m_PendingTimeout = 5000;
    protected int m_MaxLoadConcurrent;
    protected AtomicInteger m_LoadConcurrent;
    protected CacheNode<K, V> m_UpdatedChain;
    protected volatile long m_GetCount;
    protected volatile long m_LoadCount;

    public LruCache(String name) {
        this.m_Name = name;
    }

    public LruCache(int maxCapacity, String name) {
        this.m_Name = name;
        this.setMaxCapacity(maxCapacity);
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public void setTimeout(int seconds) {
        this.m_Timeout = seconds;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setNullTimeout(int seconds) {
        this.m_NullTimeout = seconds;
    }

    public int getNullTimeout() {
        return this.m_NullTimeout;
    }

    public int getPendingTimeout() {
        return this.m_PendingTimeout;
    }

    public void setPendingTimeout(int mills) {
        this.m_PendingTimeout = mills;
    }

    public int getMaxLoadConcurrent() {
        return this.m_MaxLoadConcurrent;
    }

    public void setMaxLoadConcurrent(int max) {
        this.m_MaxLoadConcurrent = max;
        if (max <= 0) {
            this.m_LoadConcurrent = null;
            this.m_MaxLoadConcurrent = 0;
        } else if (this.m_LoadConcurrent == null) {
            this.m_LoadConcurrent = new AtomicInteger();
        }
    }

    public void setReachable(boolean enabled) {
        this.m_Options = enabled ? (this.m_Options |= 0x20000000) : (this.m_Options &= 0xDFFFFFFF);
    }

    boolean isReachable() {
        return 0x20000000 == (0x20000000 & this.m_Options);
    }

    public V getHintLoad(K key, Loader<K, V> loader) {
        if (key == null) {
            return null;
        }
        int hash = LruCache.hash(key);
        LruHashMap.Node node = this.openNode(hash, (Object)key);
        Object v = ((CacheNode)node).getValue();
        if (v != null) {
            this.afterNodeAccess(node);
            return v;
        }
        if (((CacheNode)node).reloadNull(this.m_NullTimeout)) {
            this.afterNodeAccess(node);
            return v;
        }
        v = this.load((CacheNode<K, V>)node, loader, false);
        return v;
    }

    public V getHintLoad(K key, Loader<K, V> loader, int expire) {
        if (key == null) {
            return null;
        }
        int hash = LruCache.hash(key);
        LruHashMap.Node node = this.openNode(hash, (Object)key);
        Object v = ((CacheNode)node).getValue();
        if (v != null) {
            if (((CacheNode)node).isReady(v, expire)) {
                this.afterNodeAccess(node);
                return v;
            }
            ((CacheNode)node).reinit();
            try {
                v = this.load((CacheNode<K, V>)node, loader, false);
            }
            catch (Throwable e) {
                if (v != null) {
                    _Logger.warn("\u7f13\u5b58\u9879\u8fc7\u671f(" + expire + ")\u91cd\u52a0\u8f7d\u5931\u8d25\uff0c\u4fdd\u6301\u65e7\u503c" + node, e);
                }
                ((CacheNode)node).ready(v);
                throw e;
            }
            return v;
        }
        if (((CacheNode)node).reloadNull(this.m_NullTimeout)) {
            this.afterNodeAccess(node);
            return v;
        }
        v = this.load((CacheNode<K, V>)node, loader, false);
        return v;
    }

    public V getAndLoad(K key, Loader<K, V> loader, int expire) {
        if (key == null) {
            return null;
        }
        int hash = LruCache.hash(key);
        LruHashMap.Node node = this.openNode(hash, (Object)key);
        Object v = ((CacheNode)node).getValue();
        if (v != null && ((CacheNode)node).isReady(v, expire)) {
            this.afterNodeAccess(node);
            return v;
        }
        ((CacheNode)node).reinit();
        try {
            v = this.load((CacheNode<K, V>)node, loader, false);
        }
        catch (Throwable e) {
            ((CacheNode)node).ready(v);
            if (v != null) {
                _Logger.warn("\u7f13\u5b58\u9879\u8fc7\u671f(" + expire + ")\u91cd\u52a0\u8f7d\u5931\u8d25\uff0c\u4fdd\u6301\u65e7\u503c" + node, e);
            }
            throw e;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V update(K key, Updater<K, V> updater) {
        Object v;
        if (key == null) {
            return null;
        }
        int hash = LruCache.hash(key);
        LruHashMap.Node node = this.openNode(hash, (Object)key);
        if (updater != null) {
            LruHashMap.Node node2 = node;
            synchronized (node2) {
                v = ((CacheNode)node).getValue();
                v = updater.update(key, v);
                ((CacheNode)node).setValue(v);
            }
        } else {
            v = ((CacheNode)node).getValueFast();
        }
        this.afterNodeUpdate(node);
        return v;
    }

    public boolean markUpdated(K key) {
        if (key == null) {
            return false;
        }
        int hash = LruCache.hash(key);
        LruHashMap.Node node = this.getNode(hash, key);
        if (node != null) {
            ((CacheNode)node).dirty();
            this.afterNodeUpdate(node);
            return true;
        }
        return false;
    }

    @Override
    public void onGcCleanup(int policy) {
        if (this.size() == 0) {
            return;
        }
        if (4096 == (0x1000 & policy)) {
            return;
        }
        if (14 == policy && this.size() > 16) {
            if (this.trim(this.size() >> 2) > 0) {
                this.pinch();
            }
            return;
        }
        if (16 == policy && this.size() > 16) {
            this.trim(this.size());
            return;
        }
        int timeout = this.getTimeout();
        if (timeout > 0) {
            int tick = _clock.getTicker();
            CacheNode tail = (CacheNode)this.m_LruTail;
            if (tail.lastAccess + timeout < tick) {
                CacheNode last;
                if (this.idleTrim(tick - timeout) > 0) {
                    this.pinch();
                }
                tail.lastAccess = (last = (CacheNode)tail.lruBefore) == this.m_LruHead ? tick : last.lastAccess;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trimClean(int expect) {
        int over = this.size();
        int i = 0;
        int unreachables = 0;
        Object object = this.lruLock();
        synchronized (object) {
            CacheNode node;
            LruHashMap.Node p = this.m_LruTail.lruBefore;
            while (i < over && p != this.m_LruHead && p != null && unreachables < expect) {
                node = (CacheNode)p;
                p = p.lruBefore;
                if (node.isUnreachable()) {
                    this.removeNode(node.hash, node.key, null, false);
                    ++unreachables;
                } else {
                    node.detach();
                }
                ++i;
            }
            if (unreachables < expect) {
                if (i < over) {
                    this.fixLru(i);
                    return unreachables;
                }
                over = this.size();
                LruHashMap.Node end = p;
                p = this.m_LruTail.lruBefore;
                i = 0;
                while (i < over && p != end && p != this.m_LruHead && p != null && unreachables < expect) {
                    node = (CacheNode)p;
                    p = p.lruBefore;
                    if (node.isUnreachable()) {
                        this.removeNode(node.hash, node.key, null, false);
                        ++unreachables;
                    }
                    ++i;
                }
            }
        }
        if (unreachables > 0) {
            if (this.size() == 0) {
                this.clear();
            }
            _Logger.info("{unreachables:" + unreachables + ",expect:" + expect + "}" + this);
        }
        return unreachables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int trim(int expect) {
        if (this.isReachable()) {
            return this.trimClean(expect);
        }
        int count = 0;
        int i = 0;
        Object object = this.lruLock();
        synchronized (object) {
            int over = this.size();
            LruHashMap.Node p = this.m_LruTail.lruBefore;
            while (i < over && p != this.m_LruHead && p != null && count < expect) {
                CacheNode node = (CacheNode)p;
                p = p.lruBefore;
                if (!node.isDirty()) {
                    this.removeNode(node.hash, node.key, null, false);
                    ++count;
                }
                ++i;
            }
            if (i < over && count < expect) {
                this.fixLru(i);
            }
        }
        if (count > 0) {
            _Logger.info("{trim:" + count + ",expect:" + expect + "}" + this);
            if (this.size() == 0) {
                this.clear();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int idleTrim(int lastAccess) {
        int i = 0;
        int detachs = 0;
        int unreachables = 0;
        int over = this.size();
        long ts = System.currentTimeMillis();
        Object object = this.lruLock();
        synchronized (object) {
            block16: {
                if (this.m_LruTail.lruBefore != null && this.m_LruHead != this.m_LruTail.lruBefore) break block16;
                return 0;
            }
            if (this.isReachable()) {
                CacheNode node;
                LruHashMap.Node p = this.m_LruTail.lruBefore;
                while (i < over && p != this.m_LruHead && p != null) {
                    node = (CacheNode)p;
                    if (node.lastAccess > lastAccess) break;
                    p = p.lruBefore;
                    if (node.isUnreachable()) {
                        this.removeNode(node.hash, node.key, null, false);
                        ++unreachables;
                    } else if (node.detach() != null) {
                        ++detachs;
                    }
                    ++i;
                }
                while (p != this.m_LruTail && p != null) {
                    node = (CacheNode)p;
                    p = p.lruAfter;
                    if (!node.isUnreachable()) continue;
                    this.removeNode(node.hash, node.key, null, false);
                    ++unreachables;
                }
            } else {
                LruHashMap.Node p = this.m_LruTail.lruBefore;
                while (i < over && p != this.m_LruHead && p != null) {
                    CacheNode node = (CacheNode)p;
                    if (node.lastAccess <= lastAccess) {
                        p = p.lruBefore;
                        if (!node.isDirty()) {
                            this.removeNode(node.hash, node.key, null, false);
                            ++unreachables;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.size() == 0) {
            this.clear();
        }
        if ((detachs > 0 || unreachables > 0) && _Logger.isInfoEnabled() || _Logger.isTraceEnabled()) {
            _Logger.info("idleTrim{name:" + this.getName() + ",detachs:" + detachs + ",size:" + this.size() + ",unreachables:" + unreachables + ",elapse:" + (System.currentTimeMillis() - ts) + ",t:" + _clock.getTicker() + ",tl:" + ((CacheNode)this.m_LruTail).lastAccess + "}");
        }
        return unreachables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private V load(CacheNode<K, V> node, Loader<K, V> loader, boolean removeFail) {
        V v;
        long ts = System.currentTimeMillis();
        CacheNode<K, V> cacheNode = node;
        synchronized (cacheNode) {
            try {
                if (this.m_PendingTimeout > 0) {
                    long timeout = System.currentTimeMillis() - ts;
                    if (timeout >= (long)this.m_PendingTimeout) throw new TimeoutException("[" + this.getName() + "]\u7b49\u5f85\u52a0\u8f7d\u5931\u8d25\u6216\u8d85\u65f6(" + (System.currentTimeMillis() - ts) + ")" + node);
                    v = node.pending((long)this.m_PendingTimeout - timeout);
                } else {
                    v = node.pending(0L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AbortException("[" + this.getName() + "]\u7b49\u5f85\u52a0\u8f7d\u88ab\u4e2d\u65ad(" + (System.currentTimeMillis() - ts) + ")" + node, e);
            }
            if (!node.isPending(v)) {
                if (node.isReady(v, 0)) {
                    return v;
                }
                _Logger.warn("[" + this.getName() + "]\u7b49\u5f85\u540e\u7ee7\u7eed\u52a0\u8f7d(" + (System.currentTimeMillis() - ts) + ")" + node);
            }
        }
        boolean succ = false;
        int maxLoadConcurrent = this.m_MaxLoadConcurrent;
        try {
            if (maxLoadConcurrent > 0 && this.m_LoadConcurrent.incrementAndGet() > maxLoadConcurrent) {
                throw new OverloadException("[" + this.getName() + "]\u52a0\u8f7d\u5e76\u53d1\u8fc7\u591a(" + maxLoadConcurrent + ") " + node);
            }
            ++this.m_LoadCount;
            v = loader.load(node.key, node);
            succ = true;
        }
        catch (Throwable throwable) {
            if (maxLoadConcurrent > 0) {
                this.m_LoadConcurrent.decrementAndGet();
            }
            CacheNode<K, V> cacheNode2 = node;
            synchronized (cacheNode2) {
                if (succ) {
                    node.ready(v);
                } else {
                    node.reinit();
                }
                node.notifyAll();
            }
            if (succ) {
                this.afterNodeLoad(node);
                throw throwable;
            } else {
                if (!removeFail) throw throwable;
                this.removeNode(node.hash, node.key, null, false);
            }
            throw throwable;
        }
        if (maxLoadConcurrent > 0) {
            this.m_LoadConcurrent.decrementAndGet();
        }
        CacheNode<K, V> cacheNode3 = node;
        synchronized (cacheNode3) {
            if (succ) {
                node.ready(v);
            } else {
                node.reinit();
            }
            node.notifyAll();
        }
        if (succ) {
            this.afterNodeLoad(node);
            return v;
        } else {
            if (!removeFail) return v;
            this.removeNode(node.hash, node.key, null, false);
        }
        return v;
    }

    protected CacheNode<K, V> getLruHead() {
        return (CacheNode)this.m_LruHead;
    }

    @Override
    protected CacheNode<K, V> openNode(int hash, K key) {
        return (CacheNode)super.openNode(hash, key);
    }

    @Override
    protected CacheNode<K, V> getNode(int hash, Object key) {
        return (CacheNode)super.getNode(hash, key);
    }

    @Override
    protected LruHashMap.Node<K, V> newNode(int hash, K key, V value, LruHashMap.Node<K, V> next) {
        return new CacheNode<K, V>(hash, key, value, next);
    }

    protected void afterNodeLoad(CacheNode<K, V> node) {
        this.putLru(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterNodeUpdate(LruHashMap.Node<K, V> p) {
        super.afterNodeUpdate(p);
        Object object = this.updatedLock();
        synchronized (object) {
            CacheNode node = (CacheNode)p;
            this.m_UpdatedChain = node.update(this.m_UpdatedChain);
        }
    }

    @Override
    protected void afterNodeRemoval(LruHashMap.Node<K, V> p) {
        super.afterNodeRemoval(p);
        CacheNode node = (CacheNode)p;
        node.discard();
    }

    @Override
    protected void afterNodeAccess(LruHashMap.Node<K, V> p) {
        ++this.m_GetCount;
        super.afterNodeAccess(p);
    }

    protected Object updatedLock() {
        return this;
    }

    protected DirtyData<V> getDirtyData(boolean copyOn, int limit) {
        if (this.m_UpdatedChain == null) {
            return _emptyDirtyData;
        }
        if (copyOn) {
            return new CopyOn(limit);
        }
        return new Direct(limit);
    }

    public int getHitRate() {
        long hits = this.m_GetCount - this.m_LoadCount;
        if (hits > 0L) {
            return (int)(hits * 100L / this.m_GetCount);
        }
        return 0;
    }

    @Override
    public String toString() {
        return "{name:" + this.getName() + ",size:" + this.size() + ",capacity:" + this.capacity() + ",threshold:" + this.m_Threshold + ",mod:" + this.m_ModCount + ",height:" + this.m_Height + ",get:" + this.m_GetCount + ",load:" + this.m_LoadCount + ",HR:" + this.getHitRate() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        Object old;
        LruHashMap.Node node;
        LruHashMap.Node node2 = node = this.openNode(LruCache.hash(key), (Object)key);
        synchronized (node2) {
            old = ((CacheNode)node).getValue();
            if (old != null) {
                return old;
            }
            try {
                old = ((CacheNode)node).pending(0L);
            }
            catch (InterruptedException e) {
                throw new AbortException(e);
            }
            if (old != null) {
                return old;
            }
            old = value;
            ((CacheNode)node).setValue(value);
        }
        this.afterNodeUpdate(node);
        return old;
    }

    public static class CacheNode<K, V>
    extends LruHashMap.Node<K, V> {
        protected volatile WeakReference<V> reference = _unassigned;
        protected int lastAccess;
        protected int lastReady;
        protected CacheNode<K, V> updatedNext;

        public CacheNode(int hash, K key, V value, LruHashMap.Node<K, V> next) {
            super(hash, key, value, next);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V detach() {
            CacheNode cacheNode = this;
            synchronized (cacheNode) {
                if (_dirty == this.reference || _pending == this.reference || this.value == null) {
                    return (V)this.value;
                }
                this.reference = new WeakReference<Object>(this.value);
                this.value = null;
                return (V)this.reference.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getValue() {
            Object v = this.value;
            if (v != null || this.reference == null || _unassigned == this.reference || _pending == this.reference || _dirty == this.reference) {
                return (V)v;
            }
            CacheNode cacheNode = this;
            synchronized (cacheNode) {
                v = this.value;
                if (v != null || this.reference == null || _pending == this.reference || this.isDirty()) {
                    return (V)v;
                }
                v = this.reference.get();
                if (v != null) {
                    this.value = v;
                    this.reference = null;
                    return (V)v;
                }
                this.reference = _unassigned;
            }
            return null;
        }

        public V getValueFast() {
            Object v = this.value;
            if (v != null) {
                return (V)v;
            }
            WeakReference<V> r = this.reference;
            return r == null ? null : (V)r.get();
        }

        public synchronized void reinit() {
            this.value = null;
            this.reference = _unassigned;
            this.lastReady = 0;
            this.updatedNext = null;
        }

        public synchronized void discard() {
            if (this.isDirty()) {
                return;
            }
            this.reinit();
        }

        @Override
        public synchronized V setValue(V v) {
            Object old = this.value;
            this.value = v;
            this.reference = _dirty;
            this.lastAccess = this.lastReady = _clock.getTicker();
            return (V)old;
        }

        public synchronized void dirty() {
            this.reference = _dirty;
            this.lastAccess = this.lastReady = _clock.getTicker();
        }

        public synchronized void clean() {
            if (_dirty == this.reference) {
                this.reference = null;
            }
            this.updatedNext = null;
        }

        public synchronized CacheNode<K, V> update(CacheNode<K, V> linked) {
            if (this.updatedNext == null && this != linked) {
                this.updatedNext = linked;
                return this;
            }
            return linked;
        }

        public synchronized void ready(V v) {
            this.value = v;
            this.reference = null;
            this.lastAccess = this.lastReady = _clock.getTicker();
        }

        public synchronized V pending(long timeout) throws InterruptedException {
            if (_pending == this.reference) {
                if (timeout > 0L) {
                    this.wait(timeout);
                } else {
                    this.wait();
                }
            }
            if (_unassigned == this.reference) {
                this.reference = _pending;
                return null;
            }
            if (_pending == this.reference) {
                return null;
            }
            return this.getValue();
        }

        public boolean isDirty() {
            return _dirty == this.reference || this.updatedNext != null;
        }

        public boolean isReady(V v, int timeout) {
            if (v == this.value && _unassigned != this.reference && _pending != this.reference) {
                if (_dirty == this.reference) {
                    return true;
                }
                if (timeout <= 0 || _clock.getTicker() < this.lastReady + timeout) {
                    return true;
                }
            }
            return false;
        }

        public synchronized boolean reloadNull(int timeout) {
            if (this.value != null || _dirty == this.reference) {
                return true;
            }
            if (_unassigned == this.reference || _pending == this.reference) {
                return false;
            }
            if (timeout <= 0 || _clock.getTicker() < this.lastReady + timeout) {
                return true;
            }
            this.reinit();
            return false;
        }

        public boolean isPending(V v) {
            return _pending == this.reference && v == this.value;
        }

        public boolean isUnreachable() {
            return this.value == null && (this.reference == null || _dirty != this.reference && _pending != this.reference && this.reference.get() == null);
        }

        public CacheNode<K, V> getLruAfter() {
            return (CacheNode)this.lruAfter;
        }

        public CacheNode<K, V> getLruBefore() {
            return (CacheNode)this.lruBefore;
        }

        public CacheNode<K, V> getUpdatedNext() {
            return this.updatedNext;
        }

        public int getLastAccess() {
            return this.lastAccess;
        }

        public int getLastReady() {
            return this.lastReady;
        }

        @Override
        protected boolean putLru(LruHashMap.Node<K, V> chain) {
            if (super.putLru(chain)) {
                this.lastAccess = _clock.getTicker();
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            int tick = _clock.getTicker();
            return "{k:" + this.key + ",t:" + (tick - this.lastAccess) + ",r:" + (tick - this.lastReady) + ",v:" + this.value + ",ref:" + this.reference + '}';
        }
    }

    protected class CopyOn
    extends SinglyLinkedLifo<CacheNode<K, V>>
    implements DirtyData<V> {
        protected SinglyLinkedLifo.Node<CacheNode<K, V>> m_Next;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CopyOn(int limit) {
            Object object = LruCache.this.updatedLock();
            synchronized (object) {
                if (limit <= 0) {
                    limit = this.size();
                }
                CacheNode p = LruCache.this.m_UpdatedChain;
                int i = 0;
                while (i < limit && p != null) {
                    CacheNode next = p.getUpdatedNext();
                    if (p.isDirty()) {
                        this.addHead(p);
                    }
                    p.clean();
                    p = next;
                    ++i;
                }
                LruCache.this.m_UpdatedChain = p;
                if (p != null && i >= this.size()) {
                    _Logger.warn("\u66f4\u65b0\u94fe\u8868\u5f02\u5e38[" + i + "]" + LruCache.this.toString());
                }
            }
        }

        public void reset() {
            this.m_Next = this.getHead();
        }

        @Override
        public boolean hasNext() {
            return this.m_Next != null;
        }

        @Override
        public V next() {
            return this.nextNode().getValueFast();
        }

        @Override
        public void begin() {
        }

        @Override
        public int commit() {
            int count = this.size();
            this.abort();
            return count;
        }

        @Override
        public void rollback() {
            this.reset();
            this.abort();
        }

        @Override
        public void abort() {
            while (this.hasNext()) {
                LruCache.this.afterNodeUpdate(this.nextNode());
            }
            this.clear();
        }

        private CacheNode<K, V> nextNode() {
            SinglyLinkedLifo.Node p = this.m_Next;
            if (p == null) {
                throw new NoSuchElementException("\u6ca1\u6709\u5566");
            }
            this.m_Next = p.getNext();
            return (CacheNode)p.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    protected class Direct
    implements DirtyData<V> {
        protected CacheNode<K, V> m_First;
        protected CacheNode<K, V> m_Next;
        protected int m_Limit;
        protected int m_Position;

        public Direct(int limit) {
            this.m_Next = LruCache.this.m_UpdatedChain;
            this.m_First = this.m_Next;
            this.m_Limit = limit <= 0 ? LruCache.this.size() : limit;
        }

        @Override
        public boolean hasNext() {
            return this.m_Next != null && this.m_Position < this.m_Limit;
        }

        @Override
        public V next() {
            CacheNode p = this.nextNode();
            return p.getValueFast();
        }

        @Override
        public void begin() {
        }

        @Override
        public void rollback() {
            this.m_Next = this.m_First;
        }

        @Override
        public void abort() {
            this.clean();
        }

        @Override
        public int commit() {
            this.clean();
            return this.m_Position;
        }

        private void clean() {
            CacheNode next;
            CacheNode p = next = this.m_First;
            while (next != null && next != this.m_Next) {
                p = next;
                next = p.getUpdatedNext();
                p.clean();
            }
            if (this.m_First == LruCache.this.m_UpdatedChain) {
                LruCache.this.m_UpdatedChain = this.m_Next;
            } else {
                _Logger.warn("\u66f4\u65b0\u94fe\u8868\u6570\u636e\u5f02\u5e38 " + LruCache.this);
            }
            this.m_First = null;
            this.m_Next = null;
        }

        private CacheNode<K, V> nextNode() {
            CacheNode p = this.m_Next;
            if (p == null) {
                throw new NoSuchElementException("\u6ca1\u6709\u5566");
            }
            ++this.m_Position;
            this.m_Next = p.getUpdatedNext();
            return p;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static interface DirtyData<V>
    extends Iterator<V> {
        public void begin();

        public int commit();

        public void rollback();

        public void abort();
    }

    static class EmptyDirtyData
    implements DirtyData<Object> {
        EmptyDirtyData() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException("empty");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void begin() {
        }

        @Override
        public int commit() {
            return 0;
        }

        @Override
        public void rollback() {
        }

        @Override
        public void abort() {
        }
    }

    public static interface Loader<K, V> {
        public V load(K var1, CacheNode<K, V> var2);
    }

    static class MarkReference
    extends WeakReference<Object> {
        String m_Name;

        public MarkReference(String name) {
            super(null);
        }

        public String toString() {
            return this.m_Name;
        }
    }

    public static interface Updater<K, V> {
        public V update(K var1, V var2);
    }
}

