/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.GcCleanable;
import cn.weforward.common.KvPair;
import cn.weforward.common.execption.OverquotaException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LruHashMap<K, V>
implements Iterable<KvPair<K, V>>,
GcCleanable {
    protected static final Logger _Logger = LoggerFactory.getLogger(LruHashMap.class);
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected Node<K, V>[] m_Table;
    protected volatile int m_Size;
    protected volatile int m_ModCount;
    protected int m_Threshold;
    protected final float m_LoadFactor;
    protected int m_MaxCapacity;
    protected final Node<K, V> m_LruHead;
    protected final Node<K, V> m_LruTail;
    protected int m_Height;

    public LruHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.m_MaxCapacity = 0x40000000;
        if (initialCapacity > this.m_MaxCapacity) {
            initialCapacity = this.m_MaxCapacity;
        }
        this.m_LoadFactor = loadFactor;
        this.m_Threshold = this.tableSizeFor(initialCapacity);
        this.m_LruHead = this.newNode(0, null, null, null);
        this.m_LruTail = this.newNode(0, null, null, null);
        this.m_LruTail.putLru(this.m_LruHead);
    }

    public LruHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LruHashMap() {
        this(0, 0.75f);
    }

    public int getMaxCapacity() {
        return this.m_MaxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCapacity(int maxCapacity) {
        Object object = this.tableLock();
        synchronized (object) {
            int oldCap;
            this.m_MaxCapacity = maxCapacity <= 0 || maxCapacity > 0x40000000 ? 0x40000000 : maxCapacity;
            Node<K, V>[] oldTab = this.m_Table;
            int n = oldCap = oldTab == null ? 0 : oldTab.length;
            if (oldCap >= this.m_MaxCapacity) {
                this.m_Threshold = Integer.MAX_VALUE;
            }
        }
    }

    public int size() {
        return this.m_Size;
    }

    public V get(Object key) {
        Node<K, V> e = this.getNode(LruHashMap.hash(key), key);
        if (e == null) {
            return null;
        }
        this.afterNodeAccess(e);
        return e.getValue();
    }

    public V put(K key, V value) {
        Node<K, V> node = this.openNode(LruHashMap.hash(key), key);
        V old = node.setValue(value);
        this.afterNodeUpdate(node);
        return old;
    }

    public V remove(Object key) {
        Node<K, V> e = this.removeNode(LruHashMap.hash(key), key, null, false);
        return e == null ? null : (V)e.value;
    }

    public void removeAll() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lruLock();
        synchronized (object) {
            Object object2 = this.tableLock();
            synchronized (object2) {
                Node<K, V>[] tab = this.m_Table;
                if (tab == null) {
                    return;
                }
                ++this.m_ModCount;
                this.m_Size = 0;
                this.m_Table = null;
                this.m_Threshold = this.tableSizeFor(16);
            }
            this.initLru();
        }
    }

    protected void initLru() {
        this.m_LruHead.removeLru();
        this.m_LruTail.putLru(this.m_LruHead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixLru(int count) {
        _Logger.warn("LRU\u65ad\u94fe[" + count + "]\uff1f" + this);
        this.initLru();
        Object object = this.tableLock();
        synchronized (object) {
            Node<K, V>[] tab = this.m_Table;
            int cap = tab.length;
            int j = 0;
            while (j < cap) {
                Node<K, V> e = tab[j];
                while (e != null) {
                    e.putLru(this.m_LruHead);
                    e = e.next;
                }
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pinch() {
        if (this.size() == 0 && this.m_Table != null) {
            this.clear();
            return;
        }
        Object object = this.tableLock();
        synchronized (object) {
            Node<K, V>[] tab = this.m_Table;
            int threshold = this.tableSizeFor(this.size());
            if (tab != null && tab.length > threshold) {
                Node[] newTab = new Node[threshold];
                _Logger.warn("pinch:" + tab.length + "=>" + newTab.length + this);
                this.m_Height = 0;
                this.pinchRebuild(tab, newTab);
                this.m_Table = newTab;
                this.m_Threshold = this.tableSizeFor(newTab.length);
            }
        }
    }

    private void pinchRebuild(Node<K, V>[] oldTab, Node<K, V>[] newTab) {
        int oldCap = oldTab.length;
        int newCap = newTab.length;
        int j = 0;
        while (j < oldCap) {
            Node<K, V> e = oldTab[j];
            if (e != null) {
                int idx;
                oldTab[j] = null;
                if (e.next == null) {
                    idx = e.hash & newCap - 1;
                    e.next = newTab[idx];
                    newTab[idx] = e;
                } else {
                    Node next;
                    int height = 1;
                    do {
                        next = e.next;
                        idx = e.hash & newCap - 1;
                        e.next = newTab[idx];
                        newTab[idx] = e;
                        ++height;
                    } while ((e = next) != null);
                    if (height > this.m_Height) {
                        this.m_Height = height;
                    }
                }
            }
            ++j;
        }
    }

    @Override
    public void onGcCleanup(int policy) {
        if (this.size() == 0) {
            if (this.m_Table != null) {
                this.clear();
            }
            return;
        }
        if (14 == policy && this.size() > 16) {
            if (this.trim(this.size() >> 2) > 0) {
                this.pinch();
            }
            return;
        }
        if (16 == policy && this.size() > 16) {
            this.clear();
            return;
        }
    }

    public boolean isLruEmpty() {
        return this.m_LruTail.lruBefore == null || this.m_LruTail.lruBefore == this.m_LruHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trim(int expect) {
        int count = 0;
        int i = 0;
        Object object = this.lruLock();
        synchronized (object) {
            int over = this.size();
            Node p = this.m_LruTail.lruBefore;
            while (i < over && p != this.m_LruHead && p != null && count < expect) {
                Node node = p;
                p = p.lruBefore;
                this.removeNode(node.hash, node.key, null, false);
                ++count;
                ++i;
            }
            if (i < over && count < expect) {
                this.fixLru(i);
            }
        }
        if (count > 0) {
            if (this.size() == 0) {
                this.clear();
            } else if (this.isLruEmpty() && this.size() > 0 && count < expect) {
                int clear = this.size();
                this.clear();
                _Logger.info("{trim:" + count + ",clear:" + clear + "}" + this);
                return count + clear;
            }
            _Logger.info("{trim:" + count + ",expect:" + expect + "}" + this);
        }
        return count;
    }

    public V getOrDefault(Object key, V defaultValue) {
        Node<K, V> e = this.getNode(LruHashMap.hash(key), key);
        if (e == null) {
            return defaultValue;
        }
        this.afterNodeAccess(e);
        return e.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        V old;
        Node<K, V> node;
        Node<K, V> node2 = node = this.openNode(LruHashMap.hash(key), key);
        synchronized (node2) {
            old = node.getValue();
            if (old != null) {
                return old;
            }
            old = value;
            node.setValue(value);
        }
        this.afterNodeUpdate(node);
        return old;
    }

    public boolean remove(Object key, Object value) {
        return this.removeNode(LruHashMap.hash(key), key, value, true) != null;
    }

    protected Object tableLock() {
        return this.m_LruTail;
    }

    protected Object lruLock() {
        return this.m_LruHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<K, V> getNode(int hash, Object key) {
        Object object = this.tableLock();
        synchronized (object) {
            Node<K, V> first;
            block7: {
                Node<K, V>[] tab;
                block6: {
                    tab = this.m_Table;
                    if (tab != null) break block6;
                    return null;
                }
                int n = tab.length;
                int i = n - 1 & hash;
                first = tab[i];
                if (first != null) break block7;
                return null;
            }
            Node<K, V> e = first;
            do {
                if (e.hash != hash || !e.key.equals(key)) continue;
                return e;
            } while ((e = e.next) != null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node<K, V> openNode(int hash, K key) {
        Node<K, Object> p;
        block9: {
            do {
                Object object = this.tableLock();
                synchronized (object) {
                    int n;
                    Node<K, V>[] tab = this.m_Table;
                    if (tab == null || (n = tab.length) == 0 || this.m_Size > this.m_Threshold) {
                        tab = this.resize();
                        n = tab.length;
                    }
                    int i = n - 1 & hash;
                    p = tab[i];
                    int height = 1;
                    while (p != null) {
                        if (p.hash == hash && (p.key == key || p.key.equals(key))) {
                            return p;
                        }
                        p = p.next;
                        ++height;
                    }
                    if (height > this.m_Height) {
                        this.m_Height = height;
                    }
                    if (this.m_Size < this.m_MaxCapacity) {
                        tab[i] = p = this.newNode(hash, key, null, tab[i]);
                        ++this.m_ModCount;
                        ++this.m_Size;
                        break block9;
                    }
                }
            } while (this.trim(1) >= 1);
            throw new OverquotaException("over max capacity:" + this.size());
        }
        this.afterNodeInsertion(p);
        return p;
    }

    protected Node<K, V>[] resize() {
        int newCap;
        Node<K, V>[] oldTab = this.m_Table;
        int oldCap = oldTab == null ? 0 : oldTab.length;
        int oldThr = this.m_Threshold;
        if (oldThr > 0 && oldCap == 0) {
            newCap = oldThr;
        } else {
            int newThr = 0;
            if (oldCap > 0) {
                if (oldCap >= this.m_MaxCapacity) {
                    this.m_Threshold = Integer.MAX_VALUE;
                    return oldTab;
                }
                newCap = oldCap << 1;
                if (newCap < this.m_MaxCapacity && oldCap >= 16) {
                    newThr = oldThr << 1;
                }
            } else {
                newCap = 16;
                newThr = 12;
            }
            if (newThr == 0) {
                int ft = (int)((float)newCap * this.m_LoadFactor);
                newThr = newCap < this.m_MaxCapacity && ft < this.m_MaxCapacity ? ft : Integer.MAX_VALUE;
            }
            this.m_Threshold = newThr;
        }
        Node[] newTab = new Node[newCap];
        this.m_Height = 0;
        if (oldTab != null) {
            this.rebuild(oldTab, oldCap, newTab, newCap);
        }
        this.m_Table = newTab;
        return newTab;
    }

    protected void rebuild(Node<K, V>[] oldTab, int oldCap, Node<K, V>[] newTab, int newCap) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace("rebuild:" + oldCap + "/" + newCap + this);
        }
        if (newTab == null) {
            return;
        }
        int j = 0;
        while (j < oldCap) {
            Node<K, V> e = oldTab[j];
            if (e != null) {
                oldTab[j] = null;
                if (e.next == null) {
                    newTab[e.hash & newCap - 1] = e;
                } else {
                    Node next;
                    Node<K, V> loHead = null;
                    Node<K, V> loTail = null;
                    Node<K, V> hiHead = null;
                    Node<K, V> hiTail = null;
                    int height = 1;
                    do {
                        next = e.next;
                        if ((e.hash & oldCap) == 0) {
                            if (loTail == null) {
                                loHead = e;
                            } else {
                                loTail.next = e;
                            }
                            loTail = e;
                        } else {
                            if (hiTail == null) {
                                hiHead = e;
                            } else {
                                hiTail.next = e;
                            }
                            hiTail = e;
                        }
                        ++height;
                    } while ((e = next) != null);
                    if (loTail != null) {
                        loTail.next = null;
                        newTab[j] = loHead;
                    }
                    if (hiTail != null) {
                        hiTail.next = null;
                        newTab[j + oldCap] = hiHead;
                    }
                    if (height > this.m_Height) {
                        this.m_Height = height;
                    }
                }
            }
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Node<K, V> removeNode(int hash, Object key, Object value, boolean matchValue) {
        Node<K, V> node;
        block14: {
            node = null;
            Object object = this.tableLock();
            synchronized (object) {
                Node<K, V>[] tab = this.m_Table;
                if (tab == null) {
                    return null;
                }
                int n = tab.length;
                int index = n - 1 & hash;
                Node<K, V> p = tab[index];
                if (p == null) {
                    return null;
                }
                if (p.hash == hash && p.key.equals(key)) {
                    node = p;
                } else if (p.next != null) {
                    Node e = p.next;
                    do {
                        if (e.hash == hash && e.key.equals(key)) {
                            node = e;
                            break;
                        }
                        p = e;
                    } while ((e = e.next) != null);
                }
                if (node == null) {
                    return null;
                }
                if (!matchValue || value == node.value || value != null && value.equals(node.value)) {
                    if (node == p) {
                        tab[index] = node.next;
                    } else {
                        p.next = node.next;
                    }
                    ++this.m_ModCount;
                    --this.m_Size;
                    break block14;
                }
                return null;
            }
        }
        this.afterNodeRemoval(node);
        return node;
    }

    final int capacity() {
        return this.m_Table != null ? this.m_Table.length : (this.m_Threshold > 0 ? this.m_Threshold : 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putLru(Node<K, V> node) {
        Object object = this.lruLock();
        synchronized (object) {
            node.putLru(this.m_LruHead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLru(Node<K, V> node) {
        Object object = this.lruLock();
        synchronized (object) {
            node.removeLru();
        }
    }

    protected Node<K, V> newNode(int hash, K key, V value, Node<K, V> next) {
        return new Node<K, V>(hash, key, value, next);
    }

    protected void afterNodeAccess(Node<K, V> p) {
        this.putLru(p);
    }

    protected void afterNodeUpdate(Node<K, V> p) {
        this.putLru(p);
    }

    protected void afterNodeInsertion(Node<K, V> p) {
    }

    protected void afterNodeRemoval(Node<K, V> p) {
        this.removeLru(p);
    }

    public String toString() {
        return "{size:" + this.m_Size + ",capacity:" + this.capacity() + ",threshold:" + this.m_Threshold + ",mod:" + this.m_ModCount + ",height:" + this.m_Height + "}";
    }

    @Override
    public Iterator<KvPair<K, V>> iterator() {
        return new HashIterator();
    }

    public Iterator<KvPair<K, V>> lru() {
        return new LruIterator();
    }

    protected final int tableSizeFor(int cap) {
        if (cap == 0) {
            return 0;
        }
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= this.m_MaxCapacity ? this.m_MaxCapacity : n + 1);
    }

    protected static final int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    class HashIterator
    implements Iterator<KvPair<K, V>> {
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = LruHashMap.this.m_ModCount;
            Node<K, V>[] tab = LruHashMap.this.m_Table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (tab != null && LruHashMap.this.m_Size > 0) {
                while (this.index < tab.length && (this.next = tab[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K, V> nextNode() {
            Node e = this.next;
            if (LruHashMap.this.m_ModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Node<K, V>[] tab = LruHashMap.this.m_Table;
                if (LruHashMap.this.m_Table != null) {
                    while (this.index < tab.length && (this.next = tab[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node<K, V> next() {
            return this.nextNode();
        }
    }

    class LruIterator
    implements Iterator<KvPair<K, V>> {
        Node<K, V> next;

        LruIterator() {
            this.next = LruHashMap.this.m_LruTail.lruBefore;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next != LruHashMap.this.m_LruHead;
        }

        @Override
        public KvPair<K, V> next() {
            Node p = this.next;
            this.next = this.next.lruBefore;
            return p;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Node<K, V>
    implements KvPair<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;
        protected Node<K, V> next;
        protected Node<K, V> lruBefore;
        protected Node<K, V> lruAfter;

        protected Node(int hash, K key, V value, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public V setValue(V v) {
            V old = this.value;
            this.value = v;
            return old;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + ":" + this.value;
        }

        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        protected void removeLru() {
            if (this.lruBefore != null) {
                this.lruBefore.lruAfter = this.lruAfter;
            }
            if (this.lruAfter != null) {
                this.lruAfter.lruBefore = this.lruBefore;
            }
            this.lruBefore = null;
            this.lruAfter = null;
        }

        protected boolean putLru(Node<K, V> chain) {
            if (chain == this.lruBefore) {
                return false;
            }
            this.removeLru();
            this.lruAfter = chain.lruAfter;
            if (this.lruAfter != null) {
                this.lruAfter.lruBefore = this;
            }
            chain.lruAfter = this;
            this.lruBefore = chain;
            return true;
        }
    }
}

