/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtil {
    public static final Logger _Logger = LoggerFactory.getLogger(NumberUtil.class);
    public static final int[] _nilInts = new int[0];
    public static final long[] _nilLongs = new long[0];
    public static final double[] _nilDoubles = new double[0];

    public static final int toInt(String str) throws NumberFormatException {
        if (str == null || str.length() == 0) {
            return 0;
        }
        char first = str.charAt(0);
        if ('0' == first && str.length() > 2) {
            first = str.charAt(1);
            if ('x' == first || 'X' == first) {
                return Integer.parseInt(str.substring(2), 16);
            }
        } else if (str.length() > 1 && ('x' == first || 'X' == first)) {
            return Integer.parseInt(str.substring(1), 16);
        }
        return Integer.parseInt(str);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            char first = str.charAt(0);
            if ('0' == first && str.length() > 2) {
                first = str.charAt(1);
                if ('x' == first || 'X' == first) {
                    return Integer.parseInt(str.substring(2), 16);
                }
            } else if (str.length() > 1 && ('x' == first || 'X' == first)) {
                return Integer.parseInt(str.substring(1), 16);
            }
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("\u89e3\u6790" + str + "\u5f02\u5e38", (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("\u89e3\u6790" + str + "\u5f02\u5e38", (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static final boolean isNumber(char ch) {
        return ch > '/' && ch < ':';
    }

    public static final boolean isNumber(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = str.length() - 1;
        while (i >= 0) {
            if (!NumberUtil.isNumber(str.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }
}

