/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.ResultPage;
import cn.weforward.common.util.AbstractResultPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class ResultPageHelper {
    public static final int MAX_SIZE_ON_FOREACH = 1000;
    static final ResultPage<?> _nil = new Empty();

    public static <E> ResultPage<E> singleton(E element) {
        return new Singleton<E>(element);
    }

    public static <E> ResultPage<E> toResultPage(List<? super E> ls) {
        if (ls.size() == 0) {
            return ResultPageHelper.empty();
        }
        if (1 == ls.size()) {
            return ResultPageHelper.singleton(ls.get(0));
        }
        return new OnList(ls);
    }

    public static <E> ResultPage<E> empty() {
        return _nil;
    }

    public static <E> ResultPage<E> reverseResultPage(ResultPage<E> rp) {
        if (rp.getCount() < 2) {
            return rp;
        }
        return new Reverse(rp);
    }

    public static <E> List<E> toList(ResultPage<E> rp, int limit) {
        return ResultPageHelper.toList(rp, null, limit);
    }

    public static <E> List<E> toList(ResultPage<E> rp, Comparator<E> c, int limit) {
        ArrayList ls;
        if (rp == null || rp.getCount() == 0) {
            return Collections.emptyList();
        }
        if (limit < 1 || limit > rp.getCount()) {
            limit = rp.getCount();
        }
        if (1 == limit) {
            rp.setPageSize(1);
            if (rp.gotoPage(1) && rp.hasNext()) {
                return Collections.singletonList(rp.next());
            }
            return Collections.emptyList();
        }
        if (c == null && List.class.isInstance(rp)) {
            List ls2 = (List)((Object)rp);
            return ls2.size() <= limit ? ls2 : ls2.subList(0, limit);
        }
        if (c == null) {
            ls = new ArrayList(limit);
            if (limit <= 128) {
                rp.setPageSize(limit);
                rp.gotoPage(1);
                for (Object e : rp) {
                    ls.add(e);
                }
            } else {
                rp.setPageSize(128);
                int i = 1;
                while (limit > 0 && rp.gotoPage(i)) {
                    for (Object e : rp) {
                        ls.add(e);
                        if (--limit <= 0) break;
                    }
                    ++i;
                }
            }
        } else {
            ArrayList array = new ArrayList(limit);
            if (limit <= 128) {
                rp.setPageSize(limit);
                rp.gotoPage(1);
                for (Object e : rp) {
                    array.add(e);
                }
            } else {
                rp.setPageSize(128);
                int i = 1;
                while (limit > 0 && rp.gotoPage(i)) {
                    for (Object e : rp) {
                        array.add(e);
                        if (--limit <= 0) break;
                    }
                    ++i;
                }
            }
            if (c != null) {
                Collections.sort(array, c);
            }
            ls = array;
        }
        return ls;
    }

    public static <E> Iterable<E> toForeach(ResultPage<E> rp) {
        if (rp.getCount() == 0) {
            return rp;
        }
        if (rp.getPage() < 2) {
            if (rp.getCount() <= 1000) {
                rp.setPageSize(rp.getCount());
                rp.setPage(1);
                return rp;
            }
            rp.setPage(1);
        }
        if (rp.getPage() == rp.getPageCount()) {
            return rp;
        }
        return new Foreach<E>(rp);
    }

    public static class Empty<E>
    implements ResultPage<E> {
        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public int getPage() {
            return 0;
        }

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public int getPageSize() {
            return 0;
        }

        @Override
        public boolean gotoPage(int page) {
            return false;
        }

        @Override
        public boolean hasPrev() {
            return false;
        }

        @Override
        public E move(int pos) {
            return null;
        }

        @Override
        public E prev() {
            return null;
        }

        @Override
        public void setPageSize(int size) {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        public void sort(Comparator<E> c, int limit) {
        }

        @Override
        public void setPage(int page) {
            throw new IndexOutOfBoundsException("over page " + page + " at empty");
        }
    }

    public static final class Foreach<E>
    implements Iterable<E>,
    Iterator<E> {
        final ResultPage<E> m_Result;

        Foreach(ResultPage<E> result) {
            this.m_Result = result;
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.m_Result.hasNext()) {
                return true;
            }
            return this.m_Result.gotoPage(this.m_Result.getPage() + 1) && this.m_Result.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("[" + this.m_Result.getPage() + "," + this.m_Result.getPageSize() + "/" + this.m_Result.getCount() + "]" + this.m_Result);
            }
            return this.m_Result.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class OnList<E>
    extends AbstractResultPage<E> {
        private List<E> m_Elements;

        private OnList(List<? super E> ls) {
            this.m_Elements = ls;
        }

        @Override
        protected E get(int idx) {
            return this.m_Elements.get(idx);
        }

        @Override
        public int getCount() {
            return this.m_Elements.size();
        }
    }

    public static final class Reverse<E>
    extends AbstractResultPage<E> {
        private ResultPage<E> m_Original;

        private Reverse(ResultPage<E> rp) {
            this.m_Original = rp;
        }

        @Override
        protected E get(int idx) {
            int ridx = this.m_Original.getCount() - 1 - idx;
            int page = 1 + ridx / this.m_Original.getPageSize();
            this.m_Original.gotoPage(page);
            int pos = ridx - (page - 1) * this.m_Original.getPageSize();
            return this.m_Original.move(pos);
        }

        @Override
        public int getCount() {
            return this.m_Original.getCount();
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + this.m_Original;
        }
    }

    public static class Singleton<E>
    implements ResultPage<E> {
        protected E element;
        protected int pos;
        protected String resultId;

        public Singleton(E element) {
            this.element = element;
            this.pos = -1;
        }

        @Override
        public int getCount() {
            return 1;
        }

        @Override
        public int getPage() {
            return this.pos < 0 ? 0 : 1;
        }

        @Override
        public int getPageCount() {
            return 1;
        }

        @Override
        public int getPageSize() {
            return 1;
        }

        @Override
        public boolean gotoPage(int page) {
            if (1 == page) {
                this.pos = 0;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasPrev() {
            return false;
        }

        @Override
        public E move(int pos) {
            if (1 == pos) {
                this.pos = 1;
                return this.element;
            }
            return null;
        }

        @Override
        public E prev() {
            if (1 == this.pos) {
                this.pos = 0;
                return this.element;
            }
            return null;
        }

        @Override
        public void setPageSize(int size) {
        }

        @Override
        public boolean hasNext() {
            return this.pos == 0;
        }

        @Override
        public E next() {
            if (this.pos == 0) {
                ++this.pos;
                return this.element;
            }
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        public void sort(Comparator<E> c, int limit) {
        }

        @Override
        public void setPage(int page) {
            if (!this.gotoPage(page)) {
                throw new IndexOutOfBoundsException("over page " + page + " at 1~" + this.getPageCount());
            }
        }
    }
}

