/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.Destroyable;
import cn.weforward.common.GcCleanable;
import org.slf4j.LoggerFactory;

public class RingBuffer<T>
implements Destroyable,
GcCleanable {
    protected T[] m_Items;
    protected volatile int m_IndexPut;
    protected volatile int m_IndexGet;
    protected volatile int m_FullCounter;
    protected volatile int m_EmtryCounter;
    protected volatile int m_HitCounter;

    private Object lockPut() {
        return this.m_Items;
    }

    private Object lockGet() {
        return this;
    }

    protected void onFull(T item) {
    }

    protected T onEmpty() {
        return null;
    }

    protected void onDestroy(T item, int index) {
    }

    protected void onInit() {
    }

    public RingBuffer(int size) {
        int v = 1;
        while ((v <<= 1) < size) {
        }
        this.m_Items = new Object[v];
        this.onInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offer(T item) {
        Object object = this.lockPut();
        synchronized (object) {
            if ((this.m_IndexGet ^ this.m_Items.length) != this.m_IndexPut) {
                this.m_Items[this.logicIndex((int)this.m_IndexPut)] = item;
                this.m_IndexPut = this.virtualIndex(this.m_IndexPut + 1);
                return true;
            }
        }
        ++this.m_FullCounter;
        this.onFull(item);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll() {
        Object object = this.lockGet();
        synchronized (object) {
            if (this.m_IndexGet != this.m_IndexPut) {
                T item = this.m_Items[this.logicIndex(this.m_IndexGet)];
                this.m_IndexGet = this.virtualIndex(this.m_IndexGet + 1);
                ++this.m_HitCounter;
                return item;
            }
        }
        ++this.m_EmtryCounter;
        return this.onEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove() {
        Object object = this.lockGet();
        synchronized (object) {
            if (this.m_IndexGet != this.m_IndexPut) {
                int idx = this.logicIndex(this.m_IndexGet);
                T item = this.m_Items[idx];
                this.m_Items[idx] = null;
                this.m_IndexGet = this.virtualIndex(this.m_IndexGet + 1);
                ++this.m_HitCounter;
                return item;
            }
        }
        ++this.m_EmtryCounter;
        return this.onEmpty();
    }

    public T item(int index) {
        return this.m_Items[index];
    }

    private int logicIndex(int index) {
        return index & this.m_Items.length - 1;
    }

    private int virtualIndex(int index) {
        return index & 2 * this.m_Items.length - 1;
    }

    public int size() {
        return this.m_Items == null ? 0 : this.m_Items.length;
    }

    public int readable() {
        int r;
        if (this.m_IndexPut == this.m_IndexGet) {
            return 0;
        }
        int w = this.logicIndex(this.m_IndexPut);
        return w > (r = this.logicIndex(this.m_IndexGet)) ? w - r : w + this.size() - r;
    }

    public int writable() {
        return this.size() - this.readable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean empty() {
        if (this.m_IndexPut == 0 && this.m_IndexGet == 0) {
            return false;
        }
        Object object = this.lockPut();
        synchronized (object) {
            Object object2 = this.lockGet();
            synchronized (object2) {
                this.m_IndexPut = 0;
                this.m_IndexGet = 0;
                int i = this.m_Items.length - 1;
                while (i >= 0) {
                    T item = this.m_Items[i];
                    this.m_Items[i] = null;
                    if (item != null) {
                        this.onDestroy(item, i);
                    }
                    --i;
                }
            }
        }
        return true;
    }

    @Override
    public void destroy() {
        this.empty();
        this.m_Items = null;
    }

    @Override
    public void onGcCleanup(int policy) {
        if (16 == policy && this.empty()) {
            LoggerFactory.getLogger(RingBuffer.class).info("memory critical do emtpy." + this);
        }
    }

    public String toString() {
        return "{size:" + this.size() + ",readable:" + this.readable() + ",ip:" + this.m_IndexPut + ",ig:" + this.m_IndexGet + ",empty:" + this.m_EmtryCounter + ",full:" + this.m_FullCounter + ",hit:" + this.m_HitCounter + "}";
    }
}

