/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.crypto.Hex;
import cn.weforward.common.util.Bytes;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SimpleUtf8Encoder {
    static final int INVAILD_CHAR = Integer.MAX_VALUE;
    final OutputStream m_Output;
    int m_HighSurrogateChar;
    byte[] m_Chip;

    public SimpleUtf8Encoder(OutputStream output) {
        this.m_Output = output;
        this.m_HighSurrogateChar = Integer.MAX_VALUE;
        this.m_Chip = new byte[4];
    }

    public void encode(CharSequence csq) throws IOException {
        this.encode(csq, 0, csq.length());
    }

    public void encode(CharSequence csq, int start, int end) throws IOException {
        byte[] buf = (byte[])Bytes.Pool._1k.poll();
        int bufPos = 0;
        int hs = this.m_HighSurrogateChar;
        try {
            while (start < end) {
                char ch = csq.charAt(start);
                if (ch < '\u0000' || ch > '\uffff') {
                    throw new UnsupportedEncodingException("\u4e0d\u5728\u5b57\u7b26\u96c6\u5185\\X" + Hex.toHex16((short)ch));
                }
                if (ch <= '\u007f') {
                    buf[bufPos++] = (byte)ch;
                } else {
                    char utf16 = ch;
                    if (utf16 >= '\u0080' && utf16 <= '\u07ff') {
                        buf[bufPos++] = (byte)(0xC0 | 0x1F & utf16 >> 6);
                        buf[bufPos++] = (byte)(0x80 | 0x3F & utf16);
                    } else if (utf16 <= '\ud7ff' || utf16 >= '\ue000') {
                        buf[bufPos++] = (byte)(0xE0 | 0xF & utf16 >> 12);
                        buf[bufPos++] = (byte)(0x80 | 0x3F & utf16 >> 6);
                        buf[bufPos++] = (byte)(0x80 | 0x3F & utf16);
                    } else if (Integer.MAX_VALUE == hs) {
                        if (ch >= '\udc00') {
                            throw new UnsupportedEncodingException("\u8f85\u52a9\u5e73\u9762\u7684\u4ee3\u7406\u5bf9\u672a\u6309\u987a\u5e8f\u51fa\u73b0(high)\uff1a" + Hex.toHex16((short)ch));
                        }
                        hs = ch;
                    } else {
                        if (ch < '\udc00') {
                            throw new UnsupportedEncodingException("\u8f85\u52a9\u5e73\u9762\u7684\u4ee3\u7406\u5bf9\u672a\u6309\u987a\u5e8f\u51fa\u73b0(low)\uff1a" + Hex.toHex16((short)ch));
                        }
                        int u32 = (0x3FF & (0xFFFF27FF & hs)) << 10;
                        u32 |= 0x3FF & (0xFFFF23FF & ch);
                        buf[bufPos++] = (byte)(0xF0 | 7 & (u32 += 65536) >> 18);
                        buf[bufPos++] = (byte)(0x80 | 0x3F & u32 >> 12);
                        buf[bufPos++] = (byte)(0x80 | 0x3F & u32 >> 6);
                        buf[bufPos++] = (byte)(0x80 | 0x3F & u32);
                        hs = Integer.MAX_VALUE;
                    }
                }
                if (bufPos + 4 > buf.length) {
                    this.m_Output.write(buf, 0, bufPos);
                    bufPos = 0;
                }
                ++start;
            }
            this.m_HighSurrogateChar = hs;
            if (bufPos > 0) {
                this.m_Output.write(buf, 0, bufPos);
            }
        }
        finally {
            Bytes.Pool._1k.offer(buf);
        }
    }

    public void encode(char ch) throws IOException {
        if (ch < '\u0000' || ch > '\uffff') {
            throw new UnsupportedEncodingException("\u4e0d\u5728\u5b57\u7b26\u96c6\u5185\\X" + Hex.toHex16((short)ch));
        }
        if (ch <= '\u007f') {
            this.m_Output.write((byte)ch);
            return;
        }
        int pos = 0;
        char utf16 = ch;
        if (utf16 >= '\u0080' && utf16 <= '\u07ff') {
            this.m_Chip[pos++] = (byte)(0xC0 | 0x1F & utf16 >> 6);
            this.m_Chip[pos++] = (byte)(0x80 | 0x3F & utf16);
        } else if (utf16 <= '\ud7ff' || utf16 >= '\ue000') {
            this.m_Chip[pos++] = (byte)(0xE0 | 0xF & utf16 >> 12);
            this.m_Chip[pos++] = (byte)(0x80 | 0x3F & utf16 >> 6);
            this.m_Chip[pos++] = (byte)(0x80 | 0x3F & utf16);
        } else if (Integer.MAX_VALUE == this.m_HighSurrogateChar) {
            if (ch >= '\udc00') {
                throw new UnsupportedEncodingException("\u8f85\u52a9\u5e73\u9762\u7684\u4ee3\u7406\u5bf9\u672a\u6309\u987a\u5e8f\u51fa\u73b0(high)\uff1a" + Hex.toHex16((short)ch));
            }
            this.m_HighSurrogateChar = ch;
        } else {
            if (ch < '\udc00') {
                throw new UnsupportedEncodingException("\u8f85\u52a9\u5e73\u9762\u7684\u4ee3\u7406\u5bf9\u672a\u6309\u987a\u5e8f\u51fa\u73b0(low)\uff1a" + Hex.toHex16((short)ch));
            }
            int u32 = (0x3FF & (0xFFFF27FF & this.m_HighSurrogateChar)) << 10;
            u32 |= 0x3FF & (0xFFFF23FF & ch);
            this.m_Chip[pos++] = (byte)(0xF0 | 7 & (u32 += 65536) >> 18);
            this.m_Chip[pos++] = (byte)(0x80 | 0x3F & u32 >> 12);
            this.m_Chip[pos++] = (byte)(0x80 | 0x3F & u32 >> 6);
            this.m_Chip[pos++] = (byte)(0x80 | 0x3F & u32);
            this.m_HighSurrogateChar = Integer.MAX_VALUE;
        }
        this.m_Output.write(this.m_Chip, 0, pos);
    }
}

