/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.execption.UnsupportedException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SinglyLinked<E>
implements Iterable<E> {
    protected volatile Node<E> m_Head;
    protected volatile Node<E> m_Tail;
    protected volatile int m_Size;

    protected Node<E> createNode(Node<E> next, E value) {
        return new Node<E>(next, value);
    }

    public int size() {
        return this.m_Size;
    }

    public boolean isEmpty() {
        return this.m_Head == null;
    }

    @Override
    public Iterator<E> iterator() {
        return new LinkedIterator<E>(this.m_Head);
    }

    public Node<E> getHead() {
        return this.m_Head;
    }

    public Node<E> removeHead() {
        Node<E> first = this.m_Head;
        if (first != null) {
            this.m_Head = first.next;
            if (this.m_Head == null) {
                this.m_Tail = null;
            }
            --this.m_Size;
        }
        return first;
    }

    public Node<E> removeTail() {
        Node<E> last = this.m_Tail;
        if (last != null) {
            if (last == this.m_Head) {
                this.m_Tail = null;
                this.m_Head = null;
            } else {
                Node<E> p = this.m_Head;
                while (p != null) {
                    if (p.next == last) {
                        this.m_Tail = p.next;
                        this.m_Tail.next = null;
                        break;
                    }
                    p = p.next;
                }
                if (last == this.m_Tail) {
                    throw new IllegalStateException("\u94fe\u8868\u6709\u95ee\u9898\uff0c\u7531\u9996\u627e\u4e0d\u56de\u5c3e\uff01");
                }
            }
            --this.m_Size;
        }
        return last;
    }

    public Node<E> addHead(E value) {
        Node<E> first = this.createNode(this.m_Head, value);
        ++this.m_Size;
        this.m_Head = first;
        if (this.m_Tail == null) {
            this.m_Tail = first;
        }
        return first;
    }

    public Node<E> addTail(E value) {
        Node<E> last = this.createNode(null, value);
        ++this.m_Size;
        if (this.m_Tail == null) {
            this.m_Head = last;
        } else {
            this.m_Tail.next = last;
        }
        this.m_Tail = last;
        return last;
    }

    public boolean addIfAbsent(E value) {
        if (this.find(value) != null) {
            return false;
        }
        this.addTail(value);
        return true;
    }

    public Node<E> find(E value) {
        Node<E> n = this.m_Head;
        while (n != null) {
            if (value.equals(n.value)) {
                return n;
            }
            n = n.next;
        }
        return null;
    }

    public boolean remove(E value) {
        Node<E> f = this.m_Head;
        if (f == null) {
            return false;
        }
        Node<E> n = f;
        while (n != null) {
            if (value.equals(n.value)) {
                if (n == this.m_Head) {
                    this.m_Head = n.next;
                    if (this.m_Head == null) {
                        this.m_Tail = null;
                    }
                } else {
                    f.next = n.next;
                    if (f.next == null) {
                        this.m_Tail = f;
                    }
                }
                --this.m_Size;
                return true;
            }
            f = n;
            n = n.next;
        }
        return false;
    }

    public Node<E> detach() {
        if (this.m_Head == null) {
            return null;
        }
        Node<E> first = this.m_Head;
        this.m_Tail = null;
        this.m_Head = null;
        this.m_Size = 0;
        return first;
    }

    public int attachToHead(Node<E> top) {
        SinglyLinkedNode p;
        Node<E> last = p = top;
        int count = 0;
        while (p != null) {
            last = p;
            ++count;
            p = p.getNext();
        }
        this.m_Size += count;
        if (this.m_Tail == null) {
            this.m_Tail = last;
        } else {
            last.next = this.m_Head;
        }
        this.m_Head = top;
        return count;
    }

    public void clear() {
        this.m_Tail = null;
        this.m_Head = null;
        this.m_Size = 0;
    }

    public String toString() {
        return "{class:\"SL\",size:" + this.m_Size + "}";
    }

    public static class LinkedIterator<E>
    implements Iterator<E> {
        protected SinglyLinkedNode<E> m_Head;
        protected SinglyLinkedNode<E> m_Next;
        protected SinglyLinkedNode<E> m_Previous;

        public LinkedIterator(SinglyLinkedNode<E> head) {
            this.m_Head = head;
            this.m_Next = head;
            this.m_Previous = null;
        }

        @Override
        public boolean hasNext() {
            return this.m_Next != null;
        }

        public SinglyLinkedNode<E> getHead() {
            return this.m_Head;
        }

        @Override
        public E next() {
            SinglyLinkedNode<E> p = this.m_Next;
            if (p == null) {
                throw new NoSuchElementException("\u6ca1\u6709\u5566");
            }
            this.m_Next = p.getNext();
            if (p == this.m_Head) {
                this.m_Previous = null;
            } else if (this.m_Previous == null) {
                this.m_Previous = this.m_Head;
            } else {
                SinglyLinkedNode<E> prev = this.m_Previous.getNext();
                if (prev != p) {
                    this.m_Previous = prev;
                }
            }
            return p.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedException("\u4e0d\u652f\u6301\u5220\u9664\u94fe\u8868\u9879");
        }
    }

    public static class Node<E>
    extends SinglyLinkedNode<E> {
        public volatile Node<E> next;

        public Node(Node<E> next, E value) {
            super(value);
            this.next = next;
        }

        @Override
        public Node<E> getNext() {
            return this.next;
        }
    }

    public static abstract class SinglyLinkedNode<E> {
        public final E value;

        public SinglyLinkedNode(E value) {
            this.value = value;
        }

        public abstract SinglyLinkedNode<E> getNext();

        public E getValue() {
            return this.value;
        }
    }
}

