/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.sys.GcCleaner;
import cn.weforward.common.util.RingBuffer;

public class StringBuilderPool
extends RingBuffer<StringBuilder> {
    protected int m_InitialCapacity;
    public static StringBuilderPool _8k = new StringBuilderPool(1024, 8192);
    public static StringBuilderPool _128 = new StringBuilderPool(2048, 128);

    public StringBuilderPool(int size, int initialCapacity) {
        super(size);
        this.m_InitialCapacity = initialCapacity;
    }

    @Override
    protected StringBuilder onEmpty() {
        return new StringBuilder(this.m_InitialCapacity);
    }

    @Override
    protected void onInit() {
        GcCleaner.register(this);
    }

    @Override
    public StringBuilder poll() {
        StringBuilder v = (StringBuilder)super.poll();
        v.setLength(0);
        return v;
    }

    @Override
    public StringBuilder remove() {
        StringBuilder v = (StringBuilder)super.remove();
        v.setLength(0);
        return v;
    }

    @Override
    public boolean offer(StringBuilder item) {
        if (item == null || item.capacity() >> 1 >= this.m_InitialCapacity) {
            return false;
        }
        return super.offer(item);
    }

    public int getInitialCapacity() {
        return this.m_InitialCapacity;
    }
}

