/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.GcCleanable;
import cn.weforward.common.crypto.Hasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringPool
implements GcCleanable {
    static final Logger _Logger = LoggerFactory.getLogger(StringPool.class);
    static final Entry[] EMPTY_TABLE = new Entry[0];
    int m_MaxCapacity;
    int m_InternMaxLength = 100;
    transient int m_Size;
    transient Entry[] m_Table = EMPTY_TABLE;
    long m_Hits;
    long m_Miss;
    long m_TooLong;

    public StringPool() {
        this.m_MaxCapacity = 1000;
    }

    public StringPool(int maxCapacity) {
        this.m_MaxCapacity = maxCapacity;
    }

    public void setMaxLength(int maxLength) {
        this.m_InternMaxLength = maxLength;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.m_MaxCapacity = maxCapacity;
    }

    private int hash(CharSequence str, int beginIndex, int endIndex) {
        return Hasher.stringHash(str, beginIndex, endIndex, 0);
    }

    private int indexFor(int hash, int len) {
        return hash & len - 1;
    }

    private boolean eq(String entry, CharSequence str, int beginIndex, int endIndex) {
        if (entry.length() != endIndex - beginIndex) {
            return false;
        }
        int i = 0;
        while (beginIndex < endIndex) {
            if (entry.charAt(i) != str.charAt(beginIndex)) {
                return false;
            }
            ++i;
            ++beginIndex;
        }
        return true;
    }

    public String intern(CharSequence str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        return this.intern(str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intern(CharSequence chars, int beginIndex, int endIndex) {
        String str;
        if (endIndex - beginIndex > this.m_InternMaxLength) {
            ++this.m_TooLong;
            return chars.subSequence(beginIndex, endIndex).toString();
        }
        int hash = this.hash(chars, beginIndex, endIndex);
        StringPool stringPool = this;
        synchronized (stringPool) {
            if (this.m_Table == EMPTY_TABLE) {
                this.m_Table = new Entry[16];
            }
            int idx = this.indexFor(hash, this.m_Table.length);
            Entry e = this.m_Table[idx];
            while (e != null) {
                if (this.eq(e.string, chars, beginIndex, endIndex)) {
                    ++this.m_Hits;
                    return e.string;
                }
                e = e.next;
            }
            str = chars.subSequence(beginIndex, endIndex).toString();
            this.addEntry(str, idx);
        }
        ++this.m_Miss;
        return str;
    }

    private void addEntry(String str, int idx) {
        if (this.m_Size >= this.m_Table.length && this.m_Table[idx] != null && this.m_Size < this.m_MaxCapacity) {
            this.resize(Math.min(2 * this.m_Table.length, this.m_MaxCapacity));
            int hash = this.hash(str, 0, str.length());
            idx = this.indexFor(hash, this.m_Table.length);
        }
        Entry e = this.m_Table[idx];
        this.m_Table[idx] = new Entry(str, e);
        ++this.m_Size;
    }

    private void resize(int size) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace("\u91cd\u5efa\u5b57\u4e32\u7f13\u51b2\u6c60[" + size + "]" + this);
        }
        Entry[] newTable = new Entry[size];
        int i = this.m_Table.length - 1;
        while (i >= 0) {
            Entry e = this.m_Table[i];
            while (e != null) {
                int idx = this.indexFor(this.hash(e.string, 0, e.string.length()), size);
                newTable[idx] = new Entry(e.string, newTable[idx]);
                e = e.next;
            }
            --i;
        }
        this.m_Table = newTable;
    }

    public synchronized void clear() {
        if (this.m_Table == null || this.m_Table.length == 0) {
            return;
        }
        _Logger.info("\u6e05\u7a7a\u5b57\u4e32\u7f13\u51b2\u6c60" + this);
        int i = this.m_Table.length - 1;
        while (i >= 0) {
            this.m_Table[i] = null;
            --i;
        }
        this.m_Size = 0;
    }

    public int size() {
        return this.m_Size;
    }

    @Override
    public void onGcCleanup(int policy) {
        if (14 == (0xFF & policy)) {
            this.clear();
        }
    }

    public String toString() {
        return "{max-c:" + this.m_MaxCapacity + ",c:" + this.m_Table.length + ",max-l:" + this.m_InternMaxLength + ",size:" + this.m_Size + ",hits:" + this.m_Hits + ",miss:" + this.m_Miss + ",long:" + this.m_TooLong + "}";
    }

    static class Entry {
        final String string;
        final Entry next;

        public Entry(String str, Entry entry) {
            this.string = str;
            this.next = entry;
        }
    }
}

