/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.crypto.Base64;
import cn.weforward.common.execption.Unexpected;
import cn.weforward.common.io.BytesOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class StringUtil {
    public static final char UNICODE_REPLACEMENT_CHAR = '\ufffd';
    public static final String UNICODE_REPLACEMENT_STRING = String.valueOf('\ufffd');
    public static final String[] _nilStrings = new String[0];
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static final boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean eq(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        return s1 != null && s1.equals(s2);
    }

    public static InputStream fromBase64String(String base64String) {
        int begin = base64String.indexOf(44) + 1;
        BytesOutputStream out = new BytesOutputStream(1 + (base64String.length() - begin) * 4 / 3);
        try {
            Base64.decode(new Base64.WrapString(base64String, begin), out);
            out.close();
            return out.detachStream();
        }
        catch (IOException e) {
            throw new Unexpected(e);
        }
    }

    public static String limit(String str, int max) {
        if (str == null || str.length() == 0 || str.length() < max) {
            return str;
        }
        str = String.valueOf(str.substring(0, max)) + "...";
        return str;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString().trim();
    }

    public static boolean isUtf8(byte[] bytes, int offset, int len) {
        boolean bAllAscii = true;
        int cOctets = 0;
        int i = offset;
        while (i < len) {
            short chr = bytes[i];
            if ((chr & 0x80) != 0) {
                bAllAscii = false;
                chr = (short)(chr + 256);
            }
            if (cOctets == 0) {
                if (chr >= 128) {
                    do {
                        chr = (short)(chr << 1);
                        cOctets = (byte)(cOctets + 1);
                    } while ((chr & 0x80) != 0);
                    if ((cOctets = (int)((byte)(cOctets - 1))) == 0) {
                        return false;
                    }
                }
            } else {
                if (128 != (chr & 0xC0)) {
                    return false;
                }
                cOctets = (byte)(cOctets - 1);
            }
            ++i;
        }
        return cOctets <= 0 && !bAllAscii;
    }

    public static final int compareTo(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static CharSequence subSequence(CharSequence str, int start, int end) throws IndexOutOfBoundsException {
        if (start == end) {
            return "";
        }
        if (start == 0 && str.length() == end) {
            return str;
        }
        return new CharSequenceSlice(str, start, end);
    }

    public static class CharSequenceSlice
    implements CharSequence {
        final CharSequence root;
        int start;
        int end;

        public CharSequenceSlice(CharSequence str, int start, int end) throws IndexOutOfBoundsException {
            if (end < start || start < 0 || end > str.length()) {
                throw new IndexOutOfBoundsException("start or end over 0~" + str.length());
            }
            this.end = end;
            this.start = start;
            this.root = str;
        }

        private int checkIndex(int index) {
            if (index < this.start || index > this.end) {
                throw new IndexOutOfBoundsException(String.valueOf(index) + " over " + this.start + "~" + this.end);
            }
            return index;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) throws IndexOutOfBoundsException {
            return this.root.charAt(this.checkIndex(this.start + index));
        }

        @Override
        public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
            return this.root.subSequence(this.checkIndex(this.start + start), this.checkIndex(this.start + end));
        }

        @Override
        public String toString() {
            return this.root.subSequence(this.start, this.end).toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CharSequence) {
                CharSequence another = (CharSequence)obj;
                int n = this.length();
                if (n == another.length()) {
                    int i = 0;
                    while (i < n) {
                        if (this.root.charAt(i + this.start) != another.charAt(i)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

