/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.DestroyableExt;
import cn.weforward.common.Nameable;
import cn.weforward.common.Quotas;
import cn.weforward.common.execption.AbortException;
import cn.weforward.common.sys.StackTracer;
import cn.weforward.common.util.LinkedPool;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool
implements Executor,
DestroyableExt,
Quotas.Governable,
Nameable {
    public static final Logger _Logger = LoggerFactory.getLogger(ThreadPool.class);
    protected LinkedPool<ThreadExt> m_Pool;
    protected String m_Name;
    protected Quotas m_Quotas;
    protected AtomicInteger m_Concurrent = new AtomicInteger();
    protected boolean m_Daemon;

    public ThreadPool(ThreadPool group) {
        if (group.m_Quotas == null) {
            group.setQuotas(new Quotas.SimpleQuotas(group.m_Pool.getMaxSize()));
        }
        this.m_Quotas = group.m_Quotas;
        this.m_Pool = group.m_Pool;
        this.m_Name = group.m_Name;
    }

    public ThreadPool(int maxThreads, String name) {
        this.m_Name = name;
        this.m_Pool = new LinkedPool<ThreadExt>(maxThreads, name){

            @Override
            protected ThreadExt onCreateElement() {
                ThreadExt thread = new ThreadExt(String.valueOf(ThreadPool.this.m_Pool.getName()) + "-" + this.getCreateTimes());
                thread.setDaemon(ThreadPool.this.m_Daemon);
                thread.start();
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug("[" + thread.getName() + "]created.");
                }
                return thread;
            }

            @Override
            protected void onCloseElement(LinkedPool.Element<ThreadExt> element) {
                ThreadExt t = element.getResource();
                if (t != null && t.isAlive()) {
                    t.interrupt();
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug(element.formatMessage("close"));
                    }
                }
            }

            @Override
            protected void onIdle(LinkedPool.Element<ThreadExt> element, int idle) {
                ThreadExt thread = element.getResource();
                if (thread != null && thread.isAlive()) {
                    element.clear();
                    thread.interrupt();
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug(element.formatMessage("idle"));
                    }
                }
            }

            @Override
            protected void onLongtime(LinkedPool.Element<ThreadExt> element, int useup) {
                String msg;
                StringBuilder builder = StringBuilderPool._8k.poll();
                try {
                    builder.append("{task-overtime-ms:").append(useup).append(",n:").append(this.getName()).append("}");
                    if (element != null) {
                        element.toString(builder, false);
                        Thread t = element.getResource();
                        if (t != null) {
                            builder.append('\n');
                            StackTracer.printStackTrace(t, (Appendable)builder);
                        }
                    }
                    msg = builder.toString();
                }
                finally {
                    StringBuilderPool._8k.offer(builder);
                }
                _Logger.warn(msg);
            }
        };
        this.setIdle(1800);
    }

    public ThreadPool byQuota() {
        return new ThreadPool(this);
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setDaemon(boolean daemon) {
        this.m_Daemon = daemon;
    }

    public void setIdle(int seconds) {
        this.m_Pool.setIdle(seconds);
    }

    public void setLongtime(int seconds) {
        this.m_Pool.setLongtime(seconds);
    }

    public void setQuotas(Quotas quotas) {
        this.m_Quotas = quotas;
    }

    public void setNolimit(boolean nolimit) {
        if (nolimit) {
            this.m_Concurrent = null;
        } else if (this.m_Concurrent == null) {
            this.m_Concurrent = new AtomicInteger();
        }
    }

    public void setQueueLengthMax(int size) {
        this.m_Pool.setQueueLengthMax(size);
    }

    public void setQueueTimeout(int mills) {
        this.m_Pool.setQueueTimeout(mills);
    }

    public int getThreads() {
        LinkedPool<ThreadExt> pool = this.m_Pool;
        return pool == null ? 0 : pool.getInUseCount();
    }

    public int getMaxThreads() {
        LinkedPool<ThreadExt> pool = this.m_Pool;
        return pool == null ? 0 : pool.getMaxSize();
    }

    public int getInQueue() {
        LinkedPool<ThreadExt> pool = this.m_Pool;
        return pool == null ? 0 : pool.getInQueue();
    }

    @Override
    public void execute(Runnable handler) {
        LinkedPool<ThreadExt> pool = this.m_Pool;
        if (pool == null) {
            throw new AbortException("[" + this.getName() + "] is shutdown." + handler);
        }
        ThreadExt thread = null;
        Quotas quotas = this.m_Quotas;
        if (quotas != null) {
            AtomicInteger c = this.m_Concurrent;
            quotas.use(this, c == null ? 0 : c.get());
        }
        try {
            thread = pool.poll();
        }
        finally {
            if (thread == null && quotas != null) {
                quotas.refund(this);
            }
        }
        if (thread == null) {
            throw new RejectedExecutionException(this.toString("\u7ebf\u7a0b\u6c60\u5fd9"));
        }
        thread.submit(handler, this);
        thread = null;
    }

    private void begin(ThreadExt thread) {
        AtomicInteger c = this.m_Concurrent;
        if (c != null) {
            c.incrementAndGet();
        }
    }

    protected void end(ThreadExt thread, boolean running) {
        AtomicInteger c = this.m_Concurrent;
        if (c != null) {
            c.decrementAndGet();
        }
        Quotas quotas = this.m_Quotas;
        LinkedPool<ThreadExt> pool = this.m_Pool;
        if (quotas != null) {
            quotas.refund(this);
        }
        if (pool != null) {
            pool.offer(thread, !running);
        }
    }

    public void shutdown() {
        LinkedPool<ThreadExt> pool = this.m_Pool;
        if (pool != null) {
            this.m_Pool = null;
            _Logger.info("shutdown " + pool);
            pool.close();
        }
    }

    @Override
    public void destroy() {
        this.shutdown();
    }

    @Override
    public boolean destroySignal() {
        LinkedPool<ThreadExt> pool = this.m_Pool;
        if (pool == null) {
            this.m_Pool = null;
            return false;
        }
        if (pool.abort() > 0) {
            pool.shutdown();
            return true;
        }
        this.shutdown();
        return false;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String msg) {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            if (!StringUtil.isEmpty(msg)) {
                builder.append(msg);
            }
            builder.append("{n:").append(this.getName());
            if (this.m_Concurrent != null) {
                builder.append(",c:").append(this.m_Concurrent);
            }
            if (this.m_Quotas != null) {
                builder.append(",quotas:").append(this.m_Quotas);
            }
            if (this.m_Pool != null) {
                builder.append(",pool:");
                this.m_Pool.toString(builder);
            }
            builder.append("}");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    public String dump() {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            builder.append("{n:").append(this.getName());
            if (this.m_Concurrent != null) {
                builder.append(",c:").append(this.m_Concurrent);
            }
            if (this.m_Quotas != null) {
                builder.append(",quotas:").append(this.m_Quotas);
            }
            if (this.m_Pool != null) {
                builder.append(",pool:");
                builder.append(this.m_Pool.dump());
            }
            builder.append("}");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Thread> getRunThreads() {
        LinkedPool<ThreadExt> pool = this.m_Pool;
        if (pool == null || pool.getInUseCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Thread> threads = new ArrayList<Thread>(pool.getInUseCount());
        LinkedPool<ThreadExt> linkedPool = pool;
        synchronized (linkedPool) {
            LinkedPool.Element n = pool.m_InUseChain;
            while (n != null) {
                threads.add((Thread)n.getResource());
                n = n.getNext();
            }
        }
        return threads;
    }

    public static class ThreadExt
    extends Thread {
        Runnable m_Handler;
        ThreadPool m_ThreadPool;

        public ThreadExt(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit(Runnable handler, ThreadPool pool) {
            ThreadExt threadExt = this;
            synchronized (threadExt) {
                if (this.m_Handler != null) {
                    throw new IllegalStateException(this.formatMessage("bugs!!\u4e0a\u4e2a\u4efb\u52a1\u8fd8\u5728\u6267\u884c\uff1f", handler));
                }
                if (!this.isAlive()) {
                    pool.end(this, false);
                    throw new IllegalStateException(this.formatMessage("bugs!!\u6b7b\u6389\u7684\u7ebf\u7a0b\uff1f", handler));
                }
                this.m_Handler = handler;
                this.m_ThreadPool = pool;
                this.notify();
            }
            String name = this.getName();
            String poolName = pool.getName();
            int idx = name.lastIndexOf(45);
            if (poolName != null && poolName.length() > 0 && (idx == 0 || idx >= 0 && !name.regionMatches(0, poolName, 0, idx - 1))) {
                name = String.valueOf(poolName) + name.substring(idx);
                this.setName(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            ThreadPool pool;
            Runnable cmd;
            boolean running = true;
            if (_Logger.isDebugEnabled()) {
                _Logger.debug(this.formatMessage("begin", null));
            }
            do {
                cmd = null;
                pool = null;
                try {
                    ThreadExt threadExt = this;
                    synchronized (threadExt) {
                        cmd = this.m_Handler;
                        pool = this.m_ThreadPool;
                        if (cmd == null || pool == null) {
                            this.wait();
                            cmd = this.m_Handler;
                            pool = this.m_ThreadPool;
                        }
                        this.m_Handler = null;
                        this.m_ThreadPool = null;
                    }
                    if (cmd != null) {
                        if (pool != null) {
                            pool.begin(this);
                            cmd.run();
                        } else {
                            _Logger.error(this.formatMessage("cmd\u975e\u7a7a\u5f02\u5e38", cmd));
                        }
                    }
                }
                catch (AbortException e) {
                    _Logger.info(this.formatMessage("\u6267\u884c\u4e2d\u6b62", null), (Throwable)e);
                    running = false;
                    boolean bl = running = running && !this.isInterrupted();
                    if (cmd == null || pool == null) continue;
                    pool.end(this, running);
                    continue;
                }
                catch (InterruptedException e) {
                    block22: {
                        if (cmd == null) break block22;
                        _Logger.info(this.formatMessage("\u5f02\u5e38\u4e2d\u65ad", cmd));
                    }
                    boolean bl = running = (running = false) && !this.isInterrupted();
                    if (cmd == null || pool == null) continue;
                    pool.end(this, running);
                    continue;
                }
                catch (Exception e) {
                    _Logger.info(this.formatMessage("\u6267\u884c\u5f02\u5e38", null), (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            boolean bl = running = running && !this.isInterrupted();
                            if (cmd != null && pool != null) {
                                pool.end(this, running);
                            }
                            throw throwable;
                        }
                    }
                    boolean bl = running = running && !this.isInterrupted();
                    if (cmd == null || pool == null) continue;
                    pool.end(this, running);
                    continue;
                }
                boolean bl = running = running && !this.isInterrupted();
                if (cmd == null || pool == null) continue;
                pool.end(this, running);
            } while (running);
            cmd = this.m_Handler;
            pool = this.m_ThreadPool;
            if (pool != null || cmd != null) {
                _Logger.warn(this.formatMessage("bugs!!", null));
                if (pool != null) {
                    pool.end(this, false);
                }
            } else if (_Logger.isDebugEnabled()) {
                _Logger.debug(this.formatMessage("exit", null));
            }
        }

        protected String formatMessage(String msg, Runnable cmd) {
            StringBuilder builder = StringBuilderPool._8k.poll();
            try {
                if (!StringUtil.isEmpty(msg)) {
                    builder.append(msg);
                }
                builder.append("{n:").append(this.getName());
                if (this.m_Handler != null) {
                    builder.append(",handler:").append(this.m_Handler);
                }
                if (this.m_ThreadPool != null) {
                    builder.append(",pool:").append(this.m_ThreadPool);
                }
                if (cmd != null) {
                    builder.append(",cmd:").append(cmd);
                }
                builder.append('}');
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderPool._8k.offer(builder);
            }
        }
    }
}

