/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.Nameable;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.RingBuffer;
import cn.weforward.common.util.StringUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtil {
    public static final Logger _Logger = LoggerFactory.getLogger(TimeUtil.class);
    public static final int TIMEZONE_OFFSET = TimeZone.getDefault().getRawOffset();
    public static final int HOUR_MILLS = 3600000;
    public static final int DAY_MILLS = 86400000;
    public static final Date GMT1970 = new ReadonlyDate(0L);
    public static final Date FAR_FUTURE = new ReadonlyDate(System.currentTimeMillis() + 31536000000000L);
    static final ConcurrentMap<String, DateFormatPool> _DateFormats = new ConcurrentHashMap<String, DateFormatPool>(16);
    static final DateFormat DTF_COMPACT = TimeUtil.getDateFormatInstance("yyyyMMddHHmmss");
    static final DateFormat DTF_GENERAL = TimeUtil.getDateFormatInstance("yyyy-MM-dd HH:mm:ss");
    static final DateFormat DTF_GENERAL_PARSE = TimeUtil.getDateFormatInstance("yyyy-M-d H:m:s");
    static final DateFormat DTF_GENERAL_T = TimeUtil.getDateFormatInstance("yyyy-MM-dd'T'HH:mm:ss");
    static final DateFormat DF_GENERAL = TimeUtil.getDateFormatInstance("yyyy-MM-dd");
    static final DateFormat TF_GENERAL = TimeUtil.getDateFormatInstance("HH:mm:ss");
    static final DateFormat DTF_GMT = new DateFormatPool("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    static final DateFormat DTF_CST = new DateFormatPool("EEE MMM d HH:mm:ss z yyyy", Locale.ENGLISH);
    static final DateFormat DTF_UTC = TimeUtil.getDateFormatInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static final DateFormat WF_DATE_TIME_FORMAT = TimeUtil.getDateFormatInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final TimeZone TZ_GMT = TimeZone.getTimeZone("GMT");
    static final RingBuffer<Calendar> _GmtCalendarPool = new RingBuffer<Calendar>(64){

        @Override
        protected Calendar onEmpty() {
            return Calendar.getInstance(TZ_GMT);
        }

        @Override
        public boolean offer(Calendar item) {
            if (item == null) {
                return false;
            }
            item.clear();
            return super.offer(item);
        }
    };
    protected static final char[] _TenDigits;

    static {
        DTF_GMT.setTimeZone(TZ_GMT);
        WF_DATE_TIME_FORMAT.setTimeZone(TZ_GMT);
        _TenDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }

    public static final DateFormat getWeforwardFormat() {
        return WF_DATE_TIME_FORMAT;
    }

    public static Date parseDate(String str) {
        Calendar rc;
        if (str == null || str.length() < 4) {
            return null;
        }
        Date d = null;
        if (18 == str.length() && 'T' == str.charAt(8)) {
            rc = _GmtCalendarPool.poll();
            try {
                rc.set(1, Integer.parseInt(str.substring(0, 4)));
                rc.set(2, Integer.parseInt(str.substring(4, 6)) - 1);
                rc.set(5, Integer.parseInt(str.substring(6, 8)));
                rc.set(11, Integer.parseInt(str.substring(9, 11)));
                rc.set(12, Integer.parseInt(str.substring(11, 13)));
                rc.set(13, Integer.parseInt(str.substring(13, 15)));
                rc.set(14, Integer.parseInt(str.substring(15, 18)));
                Date date = rc.getTime();
                return date;
            }
            catch (NumberFormatException e) {
                _Logger.warn("\u89e3\u6790" + str + "\u5f02\u5e38", (Throwable)e);
            }
            finally {
                _GmtCalendarPool.offer(rc);
            }
        }
        if (8 == str.length() && NumberUtil.isNumber(str)) {
            rc = _GmtCalendarPool.poll();
            try {
                rc.set(1, Integer.parseInt(str.substring(0, 4)));
                rc.set(2, Integer.parseInt(str.substring(4, 6)) - 1);
                rc.set(5, Integer.parseInt(str.substring(6, 8)));
                Date date = rc.getTime();
                return date;
            }
            catch (NumberFormatException e) {
                _Logger.warn("\u89e3\u6790" + str + "\u5f02\u5e38", (Throwable)e);
            }
            finally {
                _GmtCalendarPool.offer(rc);
            }
        }
        try {
            if (24 == str.length() && 'T' == str.charAt(10)) {
                return WF_DATE_TIME_FORMAT.parse(str);
            }
            if (-1 != str.indexOf(45)) {
                d = -1 != str.indexOf(32) ? DTF_GENERAL_PARSE.parse(str) : (-1 != str.indexOf(46) ? DTF_UTC.parse(str) : (-1 != str.indexOf(84) ? DTF_GENERAL_T.parse(str) : DF_GENERAL.parse(str)));
            } else {
                String last = str.substring(str.length() - 4).toUpperCase();
                if (" GMT".equals(last) || " UTC".equals(last) || " CST".equals(last)) {
                    d = DTF_GMT.parse(str);
                } else if (-1 != str.indexOf(" CST ")) {
                    d = DTF_CST.parse(str);
                } else if (-1 != str.indexOf(46)) {
                    d = DTF_UTC.parse(str);
                } else if (-1 != str.indexOf(58)) {
                    d = TF_GENERAL.parse(str);
                }
            }
        }
        catch (ParseException e) {
            _Logger.warn("\u89e3\u6790" + str + "\u5f02\u5e38", (Throwable)e);
        }
        return d;
    }

    public static final String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        return DTF_GENERAL.format(date);
    }

    public static final String formatDate(Date date) {
        return DF_GENERAL.format(date);
    }

    public static final String formatTime(Date date) {
        return TF_GENERAL.format(date);
    }

    public static final String formatUTC(Date date) {
        return DTF_UTC.format(date);
    }

    public static final String formatGMT(Date date) {
        return DTF_GMT.format(date);
    }

    public static final String formatCompactGMT(Date date) {
        return TimeUtil.formatCompactGMT(date, new StringBuilder(18)).toString();
    }

    public static final StringBuilder formatCompactGMT(Date date, StringBuilder builder) {
        Calendar rc = _GmtCalendarPool.poll();
        try {
            rc.setTime(date);
            TimeUtil.append4(builder, rc.get(1));
            TimeUtil.append2(builder, 1 + rc.get(2));
            TimeUtil.append2(builder, rc.get(5));
            builder.append('T');
            TimeUtil.append2(builder, rc.get(11));
            TimeUtil.append2(builder, rc.get(12));
            TimeUtil.append2(builder, rc.get(13));
            TimeUtil.append3(builder, rc.get(14));
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
        return builder;
    }

    public static final String formatCompactDateGMT(Date date) {
        return TimeUtil.formatCompactDateGMT(date, new StringBuilder(8)).toString();
    }

    public static final StringBuilder formatCompactDateGMT(Date date, StringBuilder builder) {
        Calendar rc = _GmtCalendarPool.poll();
        try {
            rc.setTime(date);
            TimeUtil.append4(builder, rc.get(1));
            TimeUtil.append2(builder, 1 + rc.get(2));
            TimeUtil.append2(builder, rc.get(5));
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
        return builder;
    }

    public static final StringBuilder formatYyyyMmDdHhGMT(Date date, StringBuilder builder) {
        Calendar rc = _GmtCalendarPool.poll();
        try {
            rc.setTime(date);
            TimeUtil.append4(builder, rc.get(1));
            TimeUtil.append2(builder, 1 + rc.get(2));
            TimeUtil.append2(builder, rc.get(5));
            TimeUtil.append2(builder, rc.get(11));
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
        return builder;
    }

    public static final StringBuilder formatYyyyMmDdHhGMT(long millis, StringBuilder builder) {
        Calendar rc = _GmtCalendarPool.poll();
        try {
            rc.setTimeInMillis(millis);
            TimeUtil.append4(builder, rc.get(1));
            TimeUtil.append2(builder, 1 + rc.get(2));
            TimeUtil.append2(builder, rc.get(5));
            TimeUtil.append2(builder, rc.get(11));
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
        return builder;
    }

    public static final String formatYyyyMmDdHhGMT(Date date) {
        return TimeUtil.formatYyyyMmDdHhGMT(date, new StringBuilder(10)).toString();
    }

    public static final String formatCompactDate(Date date) {
        return TimeUtil.formatCompactDate(date, new StringBuilder(8)).toString();
    }

    public static final StringBuilder formatCompactDate(Date date, StringBuilder builder) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        TimeUtil.append4(builder, c.get(1));
        TimeUtil.append2(builder, 1 + c.get(2));
        TimeUtil.append2(builder, c.get(5));
        return builder;
    }

    public static final StringBuilder formatCompactDateTime(Date date, StringBuilder builder) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        TimeUtil.append4(builder, c.get(1));
        TimeUtil.append2(builder, 1 + c.get(2));
        TimeUtil.append2(builder, c.get(5));
        TimeUtil.append2(builder, c.get(11));
        TimeUtil.append2(builder, c.get(12));
        TimeUtil.append2(builder, c.get(13));
        return builder;
    }

    public static final String formatCompactDateTime(Date date) {
        return TimeUtil.formatCompactDateTime(date, new StringBuilder(14)).toString();
    }

    public static final StringBuilder formatTimestamp(long timestamp, StringBuilder builder) {
        if (builder == null) {
            builder = new StringBuilder(18);
        }
        Calendar rc = _GmtCalendarPool.poll();
        try {
            rc.setTimeInMillis(timestamp);
            TimeUtil.append4(builder, rc.get(1));
            TimeUtil.append2(builder, 1 + rc.get(2));
            TimeUtil.append2(builder, rc.get(5));
            builder.append('T');
            TimeUtil.append2(builder, rc.get(11));
            TimeUtil.append2(builder, rc.get(12));
            TimeUtil.append2(builder, rc.get(13));
            TimeUtil.append3(builder, rc.get(14));
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
        return builder;
    }

    public static final void formatTimestamp(long timestamp, Appendable appender) {
        if (appender == null) {
            appender = new StringBuilder(18);
        }
        Calendar rc = _GmtCalendarPool.poll();
        try {
            try {
                rc.setTimeInMillis(timestamp);
                TimeUtil.append4(appender, rc.get(1));
                TimeUtil.append2(appender, 1 + rc.get(2));
                TimeUtil.append2(appender, rc.get(5));
                appender.append('T');
                TimeUtil.append2(appender, rc.get(11));
                TimeUtil.append2(appender, rc.get(12));
                TimeUtil.append2(appender, rc.get(13));
                TimeUtil.append3(appender, rc.get(14));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
    }

    public static final String getTimestampYmdhm() {
        return TimeUtil.formatTimestampYmdhm(TimeUtil.currentTimeMillis(), null).toString();
    }

    public static final StringBuilder formatTimestampYmdhm(long ms, StringBuilder builder) {
        if (builder == null) {
            builder = new StringBuilder(12);
        }
        Calendar rc = _GmtCalendarPool.poll();
        try {
            rc.setTimeInMillis(ms);
            TimeUtil.append4(builder, rc.get(1));
            TimeUtil.append2(builder, 1 + rc.get(2));
            TimeUtil.append2(builder, rc.get(5));
            TimeUtil.append2(builder, rc.get(11));
            TimeUtil.append2(builder, rc.get(12));
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
        return builder;
    }

    public static final StringBuilder formatTimestampMdhm(long ms, StringBuilder builder) {
        if (builder == null) {
            builder = new StringBuilder(10);
        }
        Calendar rc = _GmtCalendarPool.poll();
        try {
            rc.setTimeInMillis(ms);
            TimeUtil.append2(builder, rc.get(1) % 1000);
            TimeUtil.append2(builder, 1 + rc.get(2));
            TimeUtil.append2(builder, rc.get(5));
            TimeUtil.append2(builder, rc.get(11));
            TimeUtil.append2(builder, rc.get(12));
        }
        finally {
            _GmtCalendarPool.offer(rc);
        }
        return builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date parseTimestamp(String str) {
        Date date;
        Calendar rc;
        block13: {
            block12: {
                if (str == null || str.length() < 4) {
                    return null;
                }
                rc = null;
                if (18 != str.length() || 'T' != str.charAt(8)) break block12;
                rc = _GmtCalendarPool.poll();
                rc.set(1, Integer.parseInt(str.substring(0, 4)));
                rc.set(2, Integer.parseInt(str.substring(4, 6)) - 1);
                rc.set(5, Integer.parseInt(str.substring(6, 8)));
                rc.set(11, Integer.parseInt(str.substring(9, 11)));
                rc.set(12, Integer.parseInt(str.substring(11, 13)));
                rc.set(13, Integer.parseInt(str.substring(13, 15)));
                rc.set(14, Integer.parseInt(str.substring(15, 18)));
                Date date2 = rc.getTime();
                _GmtCalendarPool.offer(rc);
                return date2;
            }
            if (NumberUtil.isNumber(str)) break block13;
            _GmtCalendarPool.offer(rc);
            return null;
        }
        try {
            rc = _GmtCalendarPool.poll();
            rc.set(1, Integer.parseInt(str.substring(0, 4)));
            if (str.length() >= 6) {
                rc.set(2, Integer.parseInt(str.substring(4, 6)) - 1);
                if (str.length() >= 8) {
                    rc.set(5, Integer.parseInt(str.substring(6, 8)));
                    if (str.length() >= 10) {
                        rc.set(11, Integer.parseInt(str.substring(8, 10)));
                        if (str.length() >= 12) {
                            rc.set(12, Integer.parseInt(str.substring(10, 12)));
                            if (str.length() >= 14) {
                                rc.set(13, Integer.parseInt(str.substring(12, 14)));
                            }
                        }
                    }
                }
            }
            date = rc.getTime();
        }
        catch (NumberFormatException e) {
            try {
                _Logger.warn("\u89e3\u6790" + str + "\u5f02\u5e38", (Throwable)e);
                _GmtCalendarPool.offer(rc);
            }
            catch (Throwable throwable) {
                _GmtCalendarPool.offer(rc);
                throw throwable;
            }
            return null;
        }
        _GmtCalendarPool.offer(rc);
        return date;
    }

    public static final void append(Appendable appender, int val) {
        try {
            if (val < 0) {
                val = -val;
                appender.append('-');
            }
            if (val >= 10) {
                if (val >= 100) {
                    if (val >= 1000) {
                        if (val >= 10000) {
                            if (val >= 100000) {
                                if (val >= 1000000) {
                                    if (val >= 10000000) {
                                        if (val >= 100000000) {
                                            if (val >= 1000000000) {
                                                appender.append(_TenDigits[val / 1000000000]);
                                                val %= 1000000000;
                                            }
                                            appender.append(_TenDigits[val / 100000000]);
                                            val %= 100000000;
                                        }
                                        appender.append(_TenDigits[val / 10000000]);
                                        val %= 10000000;
                                    }
                                    appender.append(_TenDigits[val / 1000000]);
                                    val %= 1000000;
                                }
                                appender.append(_TenDigits[val / 100000]);
                                val %= 100000;
                            }
                            appender.append(_TenDigits[val / 10000]);
                            val %= 10000;
                        }
                        appender.append(_TenDigits[val / 1000]);
                        val %= 1000;
                    }
                    appender.append(_TenDigits[val / 100]);
                    val %= 100;
                }
                appender.append(_TenDigits[val / 10]);
                val %= 10;
            }
            appender.append(_TenDigits[val]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void append(Appendable appender, long val) {
        try {
            if (val < 0L) {
                val = -val;
                appender.append('-');
            }
            if (val >= 10L) {
                if (val >= 100L) {
                    if (val >= 1000L) {
                        if (val >= 10000L) {
                            if (val >= 100000L) {
                                if (val >= 1000000L) {
                                    if (val >= 10000000L) {
                                        if (val >= 100000000L) {
                                            if (val >= 1000000000L) {
                                                if (val >= 10000000000L) {
                                                    if (val >= 100000000000L) {
                                                        if (val >= 1000000000000L) {
                                                            if (val >= 100000000000000L) {
                                                                if (val >= 1000000000000000L) {
                                                                    if (val >= 10000000000000000L) {
                                                                        if (val >= 100000000000000000L) {
                                                                            if (val >= 1000000000000000000L) {
                                                                                appender.append(_TenDigits[(int)(val / 1000000000000000000L)]);
                                                                                val %= 1000000000000000000L;
                                                                            }
                                                                            appender.append(_TenDigits[(int)(val / 100000000000000000L)]);
                                                                            val %= 100000000000000000L;
                                                                        }
                                                                        appender.append(_TenDigits[(int)(val / 10000000000000000L)]);
                                                                        val %= 10000000000000000L;
                                                                    }
                                                                    appender.append(_TenDigits[(int)(val / 1000000000000000L)]);
                                                                    val %= 1000000000000000L;
                                                                }
                                                                appender.append(_TenDigits[(int)(val / 100000000000000L)]);
                                                                val %= 100000000000000L;
                                                            }
                                                            if (val >= 10000000000000L) {
                                                                appender.append(_TenDigits[(int)(val / 10000000000000L)]);
                                                                val %= 10000000000000L;
                                                            }
                                                            appender.append(_TenDigits[(int)(val / 1000000000000L)]);
                                                            val %= 1000000000000L;
                                                        }
                                                        appender.append(_TenDigits[(int)(val / 100000000000L)]);
                                                        val %= 100000000000L;
                                                    }
                                                    appender.append(_TenDigits[(int)(val / 10000000000L)]);
                                                    val %= 10000000000L;
                                                }
                                                appender.append(_TenDigits[(int)(val / 1000000000L)]);
                                                val %= 1000000000L;
                                            }
                                            appender.append(_TenDigits[(int)(val / 100000000L)]);
                                            val %= 100000000L;
                                        }
                                        appender.append(_TenDigits[(int)(val / 10000000L)]);
                                        val %= 10000000L;
                                    }
                                    appender.append(_TenDigits[(int)(val / 1000000L)]);
                                    val %= 1000000L;
                                }
                                appender.append(_TenDigits[(int)(val / 100000L)]);
                                val %= 100000L;
                            }
                            appender.append(_TenDigits[(int)(val / 10000L)]);
                            val %= 10000L;
                        }
                        appender.append(_TenDigits[(int)(val / 1000L)]);
                        val %= 1000L;
                    }
                    appender.append(_TenDigits[(int)(val / 100L)]);
                    val %= 100L;
                }
                appender.append(_TenDigits[(int)(val / 10L)]);
                val %= 10L;
            }
            appender.append(_TenDigits[(int)val]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void append4(Appendable appender, int val) {
        try {
            if (val >= 10) {
                if (val >= 100) {
                    if (val >= 1000) {
                        appender.append(_TenDigits[val / 1000]);
                        val %= 1000;
                    } else {
                        appender.append('0');
                    }
                    appender.append(_TenDigits[val / 100]);
                    val %= 100;
                } else {
                    appender.append('0');
                    appender.append('0');
                }
                appender.append(_TenDigits[val / 10]);
                val %= 10;
            } else {
                appender.append('0');
                appender.append('0');
                appender.append('0');
            }
            appender.append(_TenDigits[val]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void append3(Appendable appender, int val) {
        try {
            if (val >= 10) {
                if (val >= 100) {
                    appender.append(_TenDigits[val / 100]);
                    val %= 100;
                } else {
                    appender.append('0');
                }
                appender.append(_TenDigits[val / 10]);
                val %= 10;
            } else {
                appender.append('0');
                appender.append('0');
            }
            appender.append(_TenDigits[val]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void append2(Appendable appender, int val) {
        try {
            if (val >= 10) {
                appender.append(_TenDigits[val / 10]);
                val %= 10;
            } else {
                appender.append('0');
            }
            appender.append(_TenDigits[val]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSameDay(Date d1, Date d2) {
        return TimeUtil.isSameDay(d1, d2, TIMEZONE_OFFSET);
    }

    public static boolean isSameDay(Date d1, Date d2, int timezone) {
        int t2;
        if (d1 == d2) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        int t1 = (int)((d1.getTime() + (long)timezone) / 86400000L);
        return t1 == (t2 = (int)((d2.getTime() + (long)timezone) / 86400000L));
    }

    public static int compareTo(Date d1, Date d2) {
        if (d1 == d2) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        long v = d1.getTime() - d2.getTime();
        return v > 0L ? 1 : (v < 0L ? -1 : 0);
    }

    public static final int getSecondsFromTime(Date time) {
        if (time == null) {
            return 0;
        }
        return (int)(time.getTime() / 1000L);
    }

    public static final int getSecondsFromTime(long time) {
        return (int)(time / 1000L);
    }

    public static final Date getTimeFromSeconds(int seconds) {
        if (seconds == 0) {
            return GMT1970;
        }
        return new Date((long)seconds * 1000L);
    }

    public static final Date getTimeFromSeconds(long seconds) {
        if (0L == seconds) {
            return GMT1970;
        }
        return new Date(seconds * 1000L);
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static DateFormat getDateFormatInstance(String pattern) {
        if (StringUtil.isEmpty(pattern)) {
            throw new NullPointerException("pattern is <null>");
        }
        DateFormatPool df = (DateFormatPool)_DateFormats.get(pattern);
        if (df == null) {
            df = new DateFormatPool(pattern, null);
            _DateFormats.putIfAbsent(df.getName(), df);
            return df;
        }
        return df;
    }

    public static class DateFormatPool
    extends DateFormat
    implements Nameable {
        private static final long serialVersionUID = 1L;
        protected RingBuffer<SimpleDateFormat> m_Pool;
        protected final String m_Pattern;
        protected final Locale m_Locale;

        public DateFormatPool(String pattern, Locale locale) {
            this.m_Pattern = pattern;
            this.m_Locale = locale;
            this.m_Pool = new RingBuffer<SimpleDateFormat>(32){

                @Override
                protected SimpleDateFormat onEmpty() {
                    SimpleDateFormat df = DateFormatPool.this.m_Locale == null ? new SimpleDateFormat(DateFormatPool.this.m_Pattern) : new SimpleDateFormat(DateFormatPool.this.m_Pattern, DateFormatPool.this.m_Locale);
                    return df;
                }
            };
        }

        @Override
        public String getName() {
            return this.m_Pattern;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            TimeZone tz = this.getTimeZone();
            SimpleDateFormat rc = this.m_Pool.poll();
            try {
                if (tz != null) {
                    rc.setTimeZone(tz);
                }
                StringBuffer stringBuffer = rc.format(date, toAppendTo, fieldPosition);
                return stringBuffer;
            }
            finally {
                this.m_Pool.offer(rc);
            }
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            TimeZone tz = this.getTimeZone();
            SimpleDateFormat rc = this.m_Pool.poll();
            try {
                if (tz != null) {
                    rc.setTimeZone(tz);
                }
                Date date = rc.parse(source, pos);
                return date;
            }
            finally {
                this.m_Pool.offer(rc);
            }
        }

        @Override
        public void setCalendar(Calendar newCalendar) {
            throw new UnsupportedOperationException("\u5171\u4eab\u6c60\u5c01\u88c5\u7684DateFormat\u4e0d\u652f\u6301\u6b64\u8bbe\u7f6e");
        }

        @Override
        public void setLenient(boolean lenient) {
            throw new UnsupportedOperationException("\u5171\u4eab\u6c60\u5c01\u88c5\u7684DateFormat\u4e0d\u652f\u6301\u6b64\u8bbe\u7f6e");
        }

        @Override
        public void setNumberFormat(NumberFormat newNumberFormat) {
            throw new UnsupportedOperationException("\u5171\u4eab\u6c60\u5c01\u88c5\u7684DateFormat\u4e0d\u652f\u6301\u6b64\u8bbe\u7f6e");
        }

        @Override
        public void setTimeZone(TimeZone zone) {
            if (this.getCalendar() == null) {
                super.setCalendar(Calendar.getInstance(zone));
                return;
            }
            super.setTimeZone(zone);
        }

        @Override
        public TimeZone getTimeZone() {
            Calendar calendar = this.getCalendar();
            if (calendar == null) {
                return null;
            }
            return calendar.getTimeZone();
        }
    }

    public static class ReadonlyDate
    extends Date {
        private static final long serialVersionUID = 1L;

        public ReadonlyDate(long date) {
            super(date);
        }

        @Override
        public void setDate(int date) {
            throw new UnsupportedOperationException("Date object is read-only");
        }

        @Override
        public void setHours(int hours) {
            throw new UnsupportedOperationException("Date object is read-only");
        }

        @Override
        public void setMinutes(int minutes) {
            throw new UnsupportedOperationException("Date object is read-only");
        }

        @Override
        public void setMonth(int month) {
            throw new UnsupportedOperationException("Date object is read-only");
        }

        @Override
        public void setSeconds(int seconds) {
            throw new UnsupportedOperationException("Date object is read-only");
        }

        @Override
        public void setTime(long time) {
            throw new UnsupportedOperationException("Date object is read-only");
        }

        @Override
        public void setYear(int year) {
            throw new UnsupportedOperationException("Date object is read-only");
        }
    }
}

