/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public abstract class TransList<T, S>
extends AbstractList<T> {
    protected List<S> m_Originals;
    protected Object[] m_Caches;
    protected static Object EMPTY_OBJECT = new Object();

    public TransList(List<S> originals) {
        this(originals, true);
    }

    public TransList(List<S> originals, boolean useCaches) {
        if (originals == null || originals.isEmpty()) {
            this.m_Originals = Collections.emptyList();
        } else {
            this.m_Originals = originals;
            this.m_Caches = useCaches ? new Object[this.m_Originals.size()] : null;
        }
    }

    protected abstract T trans(S var1);

    @Override
    public T get(int index) {
        if (this.m_Caches != null) {
            Object e = this.m_Caches[index];
            if (e == null) {
                e = this.trans(this.m_Originals.get(index));
                this.m_Caches[index] = e == null ? EMPTY_OBJECT : e;
            }
            return (T)(e == EMPTY_OBJECT ? null : e);
        }
        return this.trans(this.m_Originals.get(index));
    }

    @Override
    public int size() {
        return this.m_Originals.size();
    }

    public static <T, S> List<T> valueOf(List<S> list, final Trans<T, S> trans) {
        return new TransList<T, S>(list){

            @Override
            protected T trans(S item) {
                return trans.trans(item);
            }
        };
    }

    public static interface Trans<T, S> {
        public T trans(S var1);
    }
}

