/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.ResultPage;
import cn.weforward.common.execption.OverloadException;
import cn.weforward.common.execption.UnsupportedException;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.ResultPageHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class UnionResultPage<E>
implements ResultPage<E> {
    protected List<ResultPage<E>> m_Pages;
    protected int m_PagePos;
    protected Comparator<E> m_Comparator;
    protected int m_Count;
    protected int m_PageSize;
    protected int m_PageCount;
    protected int m_CurrentPage;
    protected E[] m_Elements;
    protected int m_Size;
    protected int m_Position;
    static int _max_turning_pages = NumberUtil.toInt(System.getProperty("cn.weforward.common.util.UnionResultPage.max_turning_pages", null), 10000);

    public static <E> ResultPage<E> union(List<ResultPage<E>> pages, Comparator<E> comparator) {
        if (pages.size() == 0) {
            return ResultPageHelper.empty();
        }
        if (1 == pages.size()) {
            ResultPage<E> one = pages.get(0);
            if (one == null) {
                return ResultPageHelper.empty();
            }
            return one;
        }
        ArrayList<ResultPage<ResultPage<E>>> fix = new ArrayList<ResultPage<ResultPage<E>>>(pages.size());
        int count = 0;
        int i = pages.size() - 1;
        while (i >= 0) {
            ResultPage<E> rp = pages.get(i);
            if (rp.getCount() != 0) {
                fix.add(rp);
                count += rp.getCount();
            }
            --i;
        }
        if (fix.size() == 0) {
            return ResultPageHelper.empty();
        }
        if (1 == fix.size()) {
            return (ResultPage)fix.get(0);
        }
        return new UnionResultPage<E>(fix, count, comparator);
    }

    protected UnionResultPage(List<ResultPage<E>> pages, int count, Comparator<E> comparator) {
        this.m_Pages = pages;
        this.m_PagePos = pages.size() - 1;
        this.m_Count = count;
        this.m_Comparator = comparator;
        this.setPageSize(20);
    }

    @Override
    public int getCount() {
        return this.m_Count;
    }

    @Override
    public int getPage() {
        return this.m_CurrentPage;
    }

    @Override
    public int getPageCount() {
        return this.m_PageCount;
    }

    @Override
    public int getPageSize() {
        return this.m_PageSize;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean gotoPage(int page) {
        block6: {
            if (page < 1 || page > this.m_PageCount || this.m_Pages == null) {
                return false;
            }
            this.m_Position = 0;
            this.m_Size = 0;
            if (this.m_Elements == null) {
                this.m_Elements = new Object[this.m_PageSize];
            }
            if (page <= this.m_CurrentPage) break block6;
            if (UnionResultPage._max_turning_pages <= 0 || page < this.m_CurrentPage + UnionResultPage._max_turning_pages) ** GOTO lbl11
            throw new OverloadException("\u5e76\u96c6\u7ed3\u679c\u9875\u8fde\u7eed\u7ffb\u9875\u8fc7\u591a[" + this.m_CurrentPage + "->" + page + "]");
lbl-1000:
            // 1 sources

            {
                this.nextPage();
lbl11:
                // 2 sources

                ** while (this.m_CurrentPage < page)
            }
lbl12:
            // 1 sources

            return true;
        }
        if (1 == page) {
            for (ResultPage<E> e : this.m_Pages) {
                e.gotoPage(1);
            }
            this.m_CurrentPage = 0;
            this.nextPage();
            return true;
        }
        if (page < this.m_CurrentPage) {
            this.gotoPage(1);
            this.gotoPage(page);
            return true;
        }
        return false;
    }

    private void nextPage() {
        this.m_Size = 0;
        while (this.m_Size < this.m_Elements.length) {
            Object last = null;
            boolean onLast = false;
            ResultPage<E> rpLast = null;
            while (this.m_PagePos >= 0) {
                ResultPage<E> rp = this.m_Pages.get(this.m_PagePos);
                if ((rp.hasNext() || rp.gotoPage(rp.getPage() + 1)) && rp.hasNext()) {
                    Object e = rp.next();
                    if (this.m_Comparator == null) {
                        last = e;
                        rpLast = rp;
                        onLast = true;
                        break;
                    }
                    if (last == null) {
                        last = e;
                        rpLast = rp;
                        onLast = true;
                    } else if (this.m_Comparator.compare(e, last) < 0) {
                        if (rpLast != null) {
                            rpLast.prev();
                        }
                        last = e;
                        rpLast = rp;
                    } else {
                        rp.prev();
                    }
                }
                --this.m_PagePos;
            }
            if (!onLast) break;
            this.m_Elements[this.m_Size++] = last;
        }
        ++this.m_CurrentPage;
    }

    @Override
    public boolean hasPrev() {
        return this.m_Position > 0;
    }

    @Override
    public E move(int pos) {
        if (this.m_Elements != null && pos >= 0 && pos < this.m_Size) {
            this.m_Position = pos;
            return this.m_Elements[this.m_Position];
        }
        return null;
    }

    @Override
    public E prev() {
        return this.hasPrev() ? (E)this.m_Elements[--this.m_Position] : null;
    }

    @Override
    public void setPageSize(int size) {
        if (this.m_PageSize == size) {
            return;
        }
        this.m_PageSize = size;
        this.m_Elements = null;
        this.m_CurrentPage = 0;
        this.m_Position = 0;
        size = 0;
        this.m_PageCount = this.m_Count / this.m_PageSize;
        if (this.m_Count % this.m_PageSize > 0) {
            ++this.m_PageCount;
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_Elements != null && this.m_Position < this.m_Size;
    }

    @Override
    public E next() {
        return this.hasNext() ? (E)this.m_Elements[this.m_Position++] : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedException("\u6b64\u529f\u80fd\u4e0d\u652f\u6301");
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public void sort(Comparator<E> c, int limit) {
        throw new UnsupportedException("\u6b64\u529f\u80fd\u4e0d\u652f\u6301\uff1a" + c);
    }

    @Override
    public void setPage(int page) {
        this.gotoPage(page);
    }

    public String toString() {
        return "{c:" + this.getCount() + ",ps:" + this.m_PageSize + ",pc:" + this.m_PageCount + ",p:" + this.m_CurrentPage + ",pos:" + this.m_Position + ",unions:" + (this.m_Pages == null ? 0 : this.m_Pages.size()) + "}";
    }
}

