/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.util.ListUtil;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UriMatcher {
    public static final String ANY = "**";
    protected List<String> m_Uris;
    protected String m_Any;
    static final Comparator<String> _comp_string = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };

    public UriMatcher() {
        this.m_Uris = Collections.emptyList();
    }

    public UriMatcher(Collection<String> uris) {
        this.setUris(uris);
    }

    public synchronized void setUris(Collection<String> uris) {
        if (uris == null || uris.size() == 0) {
            this.m_Uris = Collections.emptyList();
            return;
        }
        String[] array = new String[uris.size()];
        array = uris.toArray(array);
        Arrays.sort(array, _comp_string);
        if (ANY.equals(array[0])) {
            this.m_Any = ANY;
            this.m_Uris = Arrays.asList(Arrays.copyOfRange(array, 1, array.length));
        } else {
            this.m_Uris = Arrays.asList(array);
        }
    }

    public synchronized void addUri(String uri) {
        this.addUris(Collections.singletonList(uri));
    }

    public synchronized void addUris(final List<String> uris) {
        final List<String> oldUris = this.m_Uris;
        if (oldUris == null) {
            this.setUris(uris);
        }
        AbstractList<String> newUris = new AbstractList<String>(){

            @Override
            public String get(int index) {
                if (index < oldUris.size()) {
                    return (String)oldUris.get(index);
                }
                return (String)uris.get(index - oldUris.size());
            }

            @Override
            public int size() {
                return oldUris.size() + uris.size();
            }
        };
        this.setUris((Collection<String>)newUris);
    }

    public synchronized void removeUri(String uri) {
        final List<String> oldUris = this.m_Uris;
        if (ListUtil.isEmpty(oldUris)) {
            return;
        }
        final int idx = oldUris.indexOf(uri);
        if (-1 == idx) {
            return;
        }
        if (1 == oldUris.size()) {
            this.setUris(Collections.emptyList());
            return;
        }
        AbstractList<String> newUris = new AbstractList<String>(){

            @Override
            public String get(int index) {
                if (index < idx) {
                    return (String)oldUris.get(index);
                }
                return (String)oldUris.get(index + 1);
            }

            @Override
            public int size() {
                return oldUris.size() - 1;
            }
        };
        this.setUris((Collection<String>)newUris);
    }

    public String match(String uri) {
        String ret = UriMatcher.match(this.m_Uris, uri);
        if (ret == null) {
            return this.m_Any;
        }
        return ret;
    }

    public static String match(List<String> uris, String uri) {
        if (uris == null || uris.size() == 0) {
            return null;
        }
        String startsWith = null;
        int i = 0;
        while (i < uris.size()) {
            String name = uris.get(i);
            int c = name.compareTo(uri);
            if (c == 0) {
                return name;
            }
            int split = name.indexOf(42);
            if (split >= 0) {
                String match;
                String prefix = name.substring(0, split);
                if (split + 2 == name.length() && '*' == name.charAt(split + 1) && uri.startsWith(prefix)) {
                    return name;
                }
                String suffix = name.substring(split + 1);
                if ((prefix.length() == 0 || uri.startsWith(prefix)) && (suffix.length() == 0 || uri.endsWith(suffix)) && -1 == (match = uri.substring(prefix.length(), uri.length() - suffix.length())).indexOf(47)) {
                    return name;
                }
            }
            if (c > 0) break;
            ++i;
        }
        return startsWith;
    }
}

