/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class UrlUtil {
    private static final char[] _HEXDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final void encodeUrl(int b, StringBuilder sb) {
        sb.append('%');
        sb.append(_HEXDigits[b >> 4 & 0xF]);
        sb.append(_HEXDigits[b & 0xF]);
    }

    public static final StringBuilder encodeUrl(String str, StringBuilder sb) {
        return UrlUtil.encodeUrl(str, ".-_*", sb);
    }

    public static final StringBuilder encodeUrl(String str, String symbols, StringBuilder sb) {
        if (str == null) {
            return sb == null ? new StringBuilder(0) : sb;
        }
        if (sb == null) {
            sb = new StringBuilder(str.length() * 3);
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            int ch = str.charAt(i);
            if (symbols.indexOf(ch) >= 0) {
                sb.append((char)ch);
            } else if (ch < 0 || ch > 127) {
                int utf16;
                int n = utf16 = ch < 0 ? 65536 + ch : ch;
                if (utf16 >= 128 && utf16 < 2047) {
                    UrlUtil.encodeUrl(0xC0 | 0x1F & utf16 >> 6, sb);
                    UrlUtil.encodeUrl(0x80 | 0x3F & utf16, sb);
                } else if (utf16 >= 2048) {
                    UrlUtil.encodeUrl(0xE0 | 0xF & utf16 >> 12, sb);
                    UrlUtil.encodeUrl(0x80 | 0x3F & utf16 >> 6, sb);
                    UrlUtil.encodeUrl(0x80 | 0x3F & utf16, sb);
                }
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                sb.append((char)ch);
            } else {
                UrlUtil.encodeUrl(ch, sb);
            }
            ++i;
        }
        return sb;
    }

    public static final String encodeUrl(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return UrlUtil.encodeUrl(str, null).toString();
    }

    public static String decodeUrl(String url) {
        if (StringUtil.isEmpty(url)) {
            return url;
        }
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

