/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.util.FileUtil;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.common.util.UrlUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionUtil {
    public static final Logger _Logger = LoggerFactory.getLogger(VersionUtil.class);
    private static ConcurrentMap<String, String> _MainVersion = new ConcurrentHashMap<String, String>();
    private static ConcurrentMap<String, String> _ImplementationVersion = new ConcurrentHashMap<String, String>();

    public static String getVersion(List<String> clazzs) {
        StringBuilder sb = StringBuilderPool._8k.poll();
        try {
            for (String s : clazzs) {
                try {
                    Class<?> classOf = Class.forName(s);
                    s = VersionUtil.getImplementationVersionByJar(classOf);
                    if (s.length() <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(s);
                }
                catch (ClassNotFoundException e) {
                    _Logger.warn(e.toString(), (Throwable)e);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(sb);
        }
    }

    public static String getMainVersionByJar(Class<?> clazz) {
        String old;
        String name = clazz.getName();
        String v = (String)_MainVersion.get(name);
        if (v == null && (old = _MainVersion.putIfAbsent(name, v = VersionUtil.getVersionByJar(clazz, "Main-Version"))) != null) {
            v = old;
        }
        return v;
    }

    public static String getMainVersionByPom() {
        File file = new File(FileUtil.getAbsolutePath("pom.xml", null));
        if (file.exists()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                NodeList list = doc.getElementsByTagName("properties");
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    NodeList childlist = node.getChildNodes();
                    int j = 0;
                    while (j < childlist.getLength()) {
                        Node child = childlist.item(j);
                        if (StringUtil.eq(child.getNodeName(), "main.version")) {
                            return child.getTextContent();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                _Logger.warn("\u89e3\u6790xml\u5f02\u5e38", (Throwable)e);
            }
        }
        return "";
    }

    public static String getImplementationVersionByJar(Class<?> clazz) {
        String old;
        String name = clazz.getName();
        String v = (String)_ImplementationVersion.get(name);
        if (v == null && (old = _ImplementationVersion.putIfAbsent(name, v = VersionUtil.getVersionByJar(clazz, "Implementation-Version"))) != null) {
            v = old;
        }
        return v;
    }

    public static String getImplementationVersionByJar(String className) {
        String v;
        block3: {
            v = (String)_ImplementationVersion.get(className);
            if (v == null) {
                try {
                    Class<?> clazz = Class.forName(className);
                    v = VersionUtil.getImplementationVersionByJar(clazz);
                }
                catch (ClassNotFoundException e) {
                    String old = _ImplementationVersion.putIfAbsent(className, v);
                    if (old == null) break block3;
                    v = old;
                }
            }
        }
        return v;
    }

    public static String getImplementationVersionByPom() {
        File file = new File(FileUtil.getAbsolutePath("pom.xml", null));
        if (file.exists()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                NodeList list = doc.getElementsByTagName("version");
                if (list.getLength() > 0) {
                    Node node = list.item(0);
                    return node.getTextContent();
                }
            }
            catch (Exception e) {
                _Logger.warn("\u89e3\u6790xml\u5f02\u5e38", (Throwable)e);
            }
        }
        return "";
    }

    public static String getVersionByJar(Class<?> clazz, String key) {
        String name;
        int idx;
        String jar;
        block11: {
            if (clazz == null) {
                return "";
            }
            jar = null;
            try {
                URL url;
                CodeSource cs = clazz.getProtectionDomain().getCodeSource();
                if (cs != null && (url = cs.getLocation()) != null) {
                    jar = UrlUtil.decodeUrl(url.getFile());
                }
            }
            catch (SecurityException cs) {
                // empty catch block
            }
            if (jar == null) {
                return "";
            }
            if (jar.startsWith("file:/")) {
                jar = jar.substring(5);
            }
            if (-1 != (idx = jar.indexOf(33))) {
                jar = jar.substring(0, idx);
            }
            try {
                idx = jar.lastIndexOf(47);
                if (-1 == idx) {
                    idx = jar.lastIndexOf(92);
                }
                if (-1 != (idx = (name = -1 != idx ? jar.substring(idx + 1) : jar).lastIndexOf(46))) break block11;
                _Logger.warn(clazz + " Not in JAR file: " + jar);
                return "";
            }
            catch (IOException e) {
                _Logger.warn("getJarVersion failed. " + clazz + " for " + jar, (Throwable)e);
                return "";
            }
        }
        name = name.substring(0, idx);
        JarFile jf = new JarFile(jar);
        Manifest mf = jf.getManifest();
        Attributes attributes = mf.getMainAttributes();
        jf.close();
        return StringUtil.toString(attributes.getValue(key));
    }

    public static int compareTo(String v1, String v2) {
        int e2;
        int e1;
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1.equals(v2)) {
            return 0;
        }
        int b1 = 0;
        int b2 = 0;
        while (true) {
            int c;
            if ((c = VersionUtil.compareTo(v1, b1, e1 = v1.indexOf(46, b1), v2, b2, e2 = v2.indexOf(46, b2))) != 0) {
                return c;
            }
            if (-1 == e1 || -1 == e2) break;
            b1 = e1 + 1;
            b2 = e2 + 1;
        }
        if (-1 != e1) {
            return 1;
        }
        if (-1 != e2) {
            return -1;
        }
        return 0;
    }

    private static int compareTo(String v1, int b1, int e1, String v2, int b2, int e2) {
        int len2;
        int len1;
        if (-1 == e1) {
            e1 = v1.length();
        }
        if (-1 == e2) {
            e2 = v2.length();
        }
        if ((len1 = e1 - b1) != (len2 = e2 - b2)) {
            return len1 > len2 ? 1 : -1;
        }
        if (len1 != v1.length()) {
            v1 = v1.substring(b1, e1);
        }
        if (len2 != v2.length()) {
            v2 = v2.substring(b2, e2);
        }
        return v1.compareTo(v2);
    }
}

