package cn.weforward.boot.test.junit;

import org.junit.After;
import org.junit.Before;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import cn.weforward.boot.SpringAnnotationApp;
import cn.weforward.boot.support.AbstractSpringApp;
import cn.weforward.common.util.StringUtil;

/**
 * Spring Annotation配置测试基类
 * 
 * @author daibo
 *
 */
public abstract class SpringAnnotationAppTest extends AbstractSpringApp {

	protected ApplicationContext context;

	public ApplicationContext getContext() {
		return context;
	}

	@Before
	public void setup() {
		init();
		try {
			AnnotationConfigApplicationContext ac = new AnnotationConfigApplicationContext();
			String springconf = System.getProperty(SPRING_CONFIG_NAME);
			if (StringUtil.isEmpty(springconf)) {
				springconf = SpringAnnotationApp.DEFAULT_SPRING_CONFIG;
			}
			String[] confs = springconf.split(";");
			for (String v : confs) {
				Class<?> annotatedClasses;
				try {
					annotatedClasses = Class.forName(v);
				} catch (ClassNotFoundException e) {
					_Logger.warn("找不到类" + v);
					continue;
				}
				ac.register(annotatedClasses);
			}
			ac.refresh();
			ac.getAutowireCapableBeanFactory().autowireBean(this);
			context = ac;
		} catch (Throwable e) {
			_Logger.error("初始化Spring容器异常", e);
			System.exit(1);
		}
	}

	@After
	public void end() {
		end(context);
	}
}
