package cn.weforward.boot.test.junit;

import org.junit.After;
import org.junit.Before;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import cn.weforward.boot.SpringXmlApp;
import cn.weforward.boot.support.AbstractSpringApp;
import cn.weforward.common.util.StringUtil;

/**
 * Spring XML配置测试基类
 * 
 * @author daibo
 *
 */
public abstract class SpringXmlAppTest extends AbstractSpringApp {

	protected ApplicationContext context;

	public ApplicationContext getContext() {
		return context;
	}

	@Before
	public void setup() {
		init();
		String springconf = System.getProperty(SPRING_CONFIG_NAME);
		if (StringUtil.isEmpty(springconf)) {
			springconf = SpringXmlApp.DEFAULT_SPRING_CONFIG;
		}
		try {
			context = new ClassPathXmlApplicationContext(
					ClassPathXmlApplicationContext.CLASSPATH_ALL_URL_PREFIX + springconf);
			context.getAutowireCapableBeanFactory().autowireBean(this);
		} catch (Throwable e) {
			_Logger.error("初始化Spring容器异常", e);
			System.exit(1);
		}
	}

	@After
	public void end() {
		end(context);
	}
}
