/**
 * Copyright (c) 2019,2020 honintech
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */
package cn.weforward.framework;

/**
 * 资源
 * 
 * @author daibo
 *
 */
public interface WeforwardResource {
	/**
	 * 资源id
	 * 
	 * @return 资源id
	 */
	String getId();

	/**
	 * 资源服务
	 * 
	 * @return 资源服务
	 */
	String getService();

	/**
	 * 资源服务编号
	 */
	String getServiceNo();

	/**
	 * 资源过期时间（自1970年1月1日起的秒数）
	 * 
	 * @return 过期时间
	 */
	long getExpire();
	
	/**
	 * 资源的Url。通常是通过调用其他资源服务获得的Url
	 */
	String getUrl();

	/**
	 * 资源外的附加数据
	 * 
	 * @return 附加数据
	 */
	Object getData();

}
