/*
 * Decompiled with CFR 0.152.
 */
package cn.wi4j.security.core.handler;

import cn.wi4j.security.core.Wic4jUserDetails;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

@Component(value="wj")
public class Wic4jPermissionHandler {
    @Autowired
    private AntPathMatcher antPathMatcher;

    public boolean hasPerm(String permission) {
        if (!StringUtils.hasText((String)permission)) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Wic4jUserDetails principal = (Wic4jUserDetails)authentication.getPrincipal();
        Collection<? extends GrantedAuthority> authorities = principal.getAuthorities();
        return this.hasPermissions(authorities.stream().map(GrantedAuthority::getAuthority).toList(), permission);
    }

    private boolean hasPermissions(List<String> permissions, String permission) {
        for (String per : permissions) {
            if (!this.antPathMatcher.match(per, permission)) continue;
            return true;
        }
        return false;
    }
}

