/*
 * Decompiled with CFR 0.152.
 */
package cn.willingxyz.restdoc.swagger2;

import cn.willingxyz.restdoc.core.models.ControllerModel;
import cn.willingxyz.restdoc.core.models.MappingModel;
import cn.willingxyz.restdoc.core.models.ParameterModel;
import cn.willingxyz.restdoc.core.models.PathModel;
import cn.willingxyz.restdoc.core.models.PropertyModel;
import cn.willingxyz.restdoc.core.models.ResponseModel;
import cn.willingxyz.restdoc.core.models.ReturnModel;
import cn.willingxyz.restdoc.core.models.RootModel;
import cn.willingxyz.restdoc.core.parse.IRestDocGenerator;
import cn.willingxyz.restdoc.core.parse.ITypeInspector;
import cn.willingxyz.restdoc.core.parse.ITypeNameParser;
import cn.willingxyz.restdoc.core.parse.utils.FormatUtils;
import cn.willingxyz.restdoc.core.parse.utils.ReflectUtils;
import cn.willingxyz.restdoc.core.parse.utils.TextUtils;
import cn.willingxyz.restdoc.core.utils.ClassNameUtils;
import cn.willingxyz.restdoc.swagger.common.SwaggerGeneratorConfig;
import cn.willingxyz.restdoc.swagger.common.utils.StringUtils;
import cn.willingxyz.restdoc.swagger2.GenericParameter;
import cn.willingxyz.restdoc.swagger2.ISwaggerFilter;
import cn.willingxyz.restdoc.swagger2.Swagger2GeneratorConfig;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import io.swagger.models.ArrayModel;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Swagger2RestDocGenerator
implements IRestDocGenerator {
    private final Swagger2GeneratorConfig _config;

    public Swagger2RestDocGenerator(Swagger2GeneratorConfig config) {
        this._config = config;
    }

    public String generate(RootModel rootModel) {
        Swagger swagger = this.generateSwagger(rootModel);
        if (this._config.isHideEmptyController()) {
            this.hideEmptyController(swagger);
        }
        if (this._config.getSwaggerFilters() != null) {
            for (ISwaggerFilter openAPIFilter : this._config.getSwaggerFilters()) {
                swagger = openAPIFilter.handle(swagger);
            }
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            String swaggerJson = objectMapper.writeValueAsString((Object)swagger);
            return swaggerJson;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u9519\u8bef");
        }
    }

    private Swagger generateSwagger(RootModel rootModel) {
        Swagger swagger = new Swagger();
        this.convertServers(rootModel, swagger);
        this.convertInfo(rootModel, swagger);
        this.convertTag(rootModel, swagger);
        this.convertPath(rootModel, swagger);
        return swagger;
    }

    private void convertTag(RootModel rootModel, Swagger swagger) {
        for (ControllerModel controller : rootModel.getControllers()) {
            Tag tag = new Tag();
            tag.setName(this.getTagName(controller));
            tag.setDescription(controller.getDescription());
            swagger.addTag(tag);
        }
    }

    private void convertInfo(RootModel rootModel, Swagger swagger) {
        Info info = new Info();
        info.setDescription(this._config.getDescription());
        info.setVersion(this._config.getVersion());
        info.setTitle(this._config.getTitle());
        swagger.setInfo(info);
    }

    private void convertServers(RootModel rootModel, Swagger swagger) {
        if (this._config.getServers() != null && this._config.getServers().size() > 0) {
            swagger.setHost(((SwaggerGeneratorConfig.ServerInfo)this._config.getServers().get(0)).getUrl());
        }
    }

    private void convertPath(RootModel rootModel, Swagger swagger) {
        for (ControllerModel controller : rootModel.getControllers()) {
            for (PathModel method : controller.getControllerMethods()) {
                for (MappingModel mapping : method.getMappings()) {
                    this.convertSinglePath(swagger, controller, method, mapping);
                }
            }
        }
    }

    private void convertSinglePath(Swagger swagger, ControllerModel controller, PathModel method, MappingModel mapping) {
        Operation operation = new Operation();
        operation.addTag(this.getTagName(controller));
        operation.setSummary(TextUtils.getFirstLine((String)method.getDescription()));
        operation.setDescription(method.getDescription());
        operation.setDeprecated(method.getDeprecated());
        for (ParameterModel param : method.getParameters()) {
            if (param.getLocation() == ParameterModel.ParameterLocation.QUERY) {
                this.convertQueryString(param, swagger).forEach(o -> operation.addParameter(o));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.BODY) {
                operation.addParameter(this.convertRequestBody(param, swagger));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.PATH) {
                operation.addParameter(this.generateSingleParameterSchema("path", param, swagger));
                continue;
            }
            if (param.getLocation() == ParameterModel.ParameterLocation.HEADER) {
                operation.addParameter(this.generateSingleParameterSchema("header", param, swagger));
                continue;
            }
            if (param.getLocation() != ParameterModel.ParameterLocation.FILE) continue;
            operation.addParameter(this.convertFileParameter(param));
        }
        operation.setResponses(this.convertResponses(method, swagger));
        for (String pathItem : mapping.getPaths()) {
            Path path = null;
            if (swagger.getPaths() != null) {
                path = swagger.getPaths().entrySet().stream().filter(o -> ((String)o.getKey()).equals(pathItem)).map(o -> (Path)o.getValue()).findFirst().orElse(null);
            }
            if (path == null) {
                path = new Path();
            }
            this.setHttpMethod(mapping, path, operation);
            swagger.path(pathItem, path);
        }
    }

    private Map<String, Response> convertResponses(PathModel method, Swagger swagger) {
        HashMap<String, Response> responses = new HashMap<String, Response>();
        for (ResponseModel res : method.getResponse()) {
            Response apiResponse = this.convertResponse(res, swagger);
            responses.put(res.getStatusCode() + "", apiResponse);
        }
        return responses;
    }

    private Response convertResponse(ResponseModel responseModel, Swagger swagger) {
        Response apiResponse = new Response();
        ReturnModel returnModel = responseModel.getReturnModel();
        apiResponse.setDescription(returnModel.getDescription());
        if (returnModel.getReturnType() == Void.TYPE || returnModel.getReturnType() == Void.class) {
            return apiResponse;
        }
        apiResponse.setResponseSchema(this.getOrGenerateModel(returnModel.getDescription(), returnModel.getReturnType(), returnModel.getChildren(), swagger));
        Property property = this.generateProperty(returnModel.getDescription(), returnModel.getReturnType(), returnModel.getChildren(), swagger);
        apiResponse.setSchema(property);
        apiResponse.setDescription(StringUtils.combineStr((String)apiResponse.getDescription(), (String)property.getDescription()));
        return apiResponse;
    }

    private Parameter convertFileParameter(ParameterModel param) {
        FormParameter requestBody = new FormParameter();
        requestBody.setDescription(param.getDescription());
        requestBody.setRequired(param.isRequired());
        return requestBody;
    }

    private Parameter convertRequestBody(ParameterModel parameterModel, Swagger swagger) {
        BodyParameter bodyParameter = new BodyParameter();
        bodyParameter.setDescription(parameterModel.getDescription());
        bodyParameter.setRequired(parameterModel.isRequired());
        Model model = this.getOrGenerateModel(parameterModel.getDescription(), parameterModel.getParameterType(), parameterModel.getChildren(), swagger);
        bodyParameter.setSchema(model);
        return bodyParameter;
    }

    private Model getOrGenerateModel(String description, Type parameterType, List<PropertyModel> children, Swagger swagger) {
        String componentName = ClassNameUtils.getComponentName((ITypeInspector)this._config.getTypeInspector(), (ITypeNameParser)this._config.getTypeNameParser(), (Type)parameterType);
        if (swagger.getDefinitions() == null) {
            swagger.setDefinitions(new HashMap());
        }
        if (!swagger.getDefinitions().containsKey(componentName)) {
            Property property = this.generateProperty(description, parameterType, children, swagger);
            ModelImpl model = null;
            if (property instanceof ObjectProperty) {
                model = new ModelImpl();
                model.setProperties(((ObjectProperty)property).getProperties());
            } else if (property instanceof ArrayProperty) {
                ArrayModel arrayModel = new ArrayModel();
                arrayModel.setItems(property);
                model = arrayModel;
            } else {
                ModelImpl modelImpl = new ModelImpl();
                modelImpl.setName(property.getName());
                modelImpl.setDescription(property.getDescription());
                modelImpl.setTitle(property.getTitle());
                modelImpl.setType(property.getType());
                modelImpl.setFormat(property.getFormat());
                if (property instanceof StringProperty) {
                    modelImpl.setEnum(((StringProperty)property).getEnum());
                    modelImpl.setDefaultValue(((StringProperty)property).getDefault());
                }
                model = modelImpl;
            }
            model.setDescription(property.getDescription());
            swagger.getDefinitions().put(componentName, model);
        }
        return (Model)swagger.getDefinitions().get(componentName);
    }

    private void setHttpMethod(MappingModel mapping, Path pathItem, Operation operation) {
        block9: for (MappingModel.HttpMethod httpMethod : mapping.getHttpMethods()) {
            switch (httpMethod) {
                case GET: {
                    pathItem.get(operation);
                    continue block9;
                }
                case PUT: {
                    pathItem.put(operation);
                    continue block9;
                }
                case POST: {
                    pathItem.post(operation);
                    continue block9;
                }
                case DELETE: {
                    pathItem.delete(operation);
                    continue block9;
                }
                case HEAD: {
                    pathItem.head(operation);
                    continue block9;
                }
                case PATCH: {
                    pathItem.patch(operation);
                    continue block9;
                }
                case OPTIONS: {
                    pathItem.options(operation);
                }
            }
        }
    }

    private List<Parameter> convertQueryString(ParameterModel paramModel, Swagger swagger) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (paramModel.getChildren() != null && paramModel.getChildren().size() > 0) {
            this.convertParameterChildren(paramModel.getChildren(), null, swagger).stream().forEach(o -> parameters.add((Parameter)o));
        } else {
            parameters.add(this.generateSingleParameterSchema("query", paramModel, swagger));
        }
        return parameters;
    }

    private List<Parameter> convertParameterChildren(List<PropertyModel> propertyModels, String paraName, Swagger swagger) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String name = "";
        if (paraName != null) {
            name = paraName + ".";
        }
        for (PropertyModel child : propertyModels) {
            if (child.isArray()) {
                this.convertParameterChildren(child.getChildren(), child.getName(), swagger).stream().forEach(o -> parameters.add((Parameter)o));
                continue;
            }
            if (child.getChildren() == null || child.getChildren().size() == 0) {
                GenericParameter parameter = new GenericParameter();
                parameter.setName(name + child.getName());
                parameter.setDescription(child.getDescription());
                parameter.setIn("query");
                Property property = this.generateProperty(child.getDescription(), child.getPropertyType(), child.getChildren(), swagger);
                parameter.setProperty(property);
                parameter.setDescription(StringUtils.combineStr((String)parameter.getDescription(), (String)property.getDescription()));
                parameters.add((Parameter)parameter);
                continue;
            }
            parameters.addAll(this.convertParameterChildren(child.getChildren(), name + child.getName(), swagger));
        }
        return parameters;
    }

    private Parameter generateSingleParameterSchema(String in, ParameterModel paramModel, Swagger swagger) {
        GenericParameter parameter = new GenericParameter();
        parameter.setIn(in);
        parameter.setName(paramModel.getName());
        parameter.setDescription(paramModel.getDescription());
        Property property = this.generateProperty(paramModel.getDescription(), paramModel.getParameterType(), paramModel.getChildren(), swagger);
        parameter.setProperty(property);
        parameter.setDescription(StringUtils.combineStr((String)parameter.getDescription(), (String)property.getDescription()));
        return parameter;
    }

    private Property generateProperty(String description, Type type, List<PropertyModel> children, Swagger swagger) {
        if (this._config.getTypeInspector().isCollection(type)) {
            return this.generateArrayProperty(description, type, children, swagger);
        }
        if (ReflectUtils.isEnum((Type)type)) {
            return this.generateEnumProperty((Class)type);
        }
        if (children == null || children.isEmpty()) {
            return this.generateSimpleTypeSchema(description, type);
        }
        return this.generateComplexSchema(type, children, swagger);
    }

    private Property generateComplexSchema(Type type, List<PropertyModel> children, Swagger swagger) {
        ObjectProperty schema = new ObjectProperty();
        ClassJavadoc classDoc = RuntimeJavadoc.getJavadoc((String)type.getTypeName());
        schema.setDescription(FormatUtils.format((Comment)classDoc.getComment()));
        schema.setProperties(this.generateComplexTypeSchemaProperty(type, children, swagger));
        return schema;
    }

    private Map<String, Property> generateComplexTypeSchemaProperty(Type type, List<PropertyModel> propertyModels, Swagger swagger) {
        HashMap<String, Property> schemas = new HashMap<String, Property>();
        for (PropertyModel propertyModel : propertyModels) {
            Property schema = this.generateProperty(propertyModel.getDescription(), propertyModel.getPropertyType(), propertyModel.getChildren(), swagger);
            schemas.put(propertyModel.getName(), schema);
        }
        return schemas;
    }

    private Property generateSimpleTypeSchema(String description, Type type) {
        ObjectProperty property = new ObjectProperty();
        property.setDescription(description);
        property.setType(this._config.getSwaggerTypeInspector().toSwaggerType(type));
        property.setFormat(this._config.getSwaggerTypeInspector().toSwaggerFormat(type));
        return property;
    }

    private Property generateArrayProperty(String description, Type type, List<PropertyModel> children, Swagger swagger) {
        ArrayProperty arrayProperty = new ArrayProperty();
        arrayProperty.setDescription(description);
        Property property = this.generateProperty(description, this._config.getTypeInspector().getCollectionComponentType(type), children, swagger);
        arrayProperty.setItems(property);
        arrayProperty.setDescription(StringUtils.combineStr((String)property.getDescription(), (String)arrayProperty.getDescription()));
        return arrayProperty;
    }

    private Property generateEnumProperty(Class clazz) {
        StringProperty property = new StringProperty();
        ClassJavadoc enumDoc = RuntimeJavadoc.getJavadoc((Class)clazz);
        String enumStr = "";
        for (FieldJavadoc enumConst : enumDoc.getEnumConstants()) {
            if (!enumStr.isEmpty()) {
                enumStr = enumStr + ", ";
            }
            enumStr = enumStr + enumConst.getName();
            String desc = FormatUtils.format((Comment)enumConst.getComment());
            if (desc == null || desc.isEmpty()) continue;
            enumStr = enumStr + ": " + desc;
        }
        String desc = FormatUtils.format((Comment)enumDoc.getComment());
        if (desc == null || desc.isEmpty()) {
            property.setDescription(enumStr);
        } else {
            property.setDescription(desc + "; " + enumStr);
        }
        List enums = Arrays.stream(clazz.getEnumConstants()).map(o -> o.toString()).collect(Collectors.toList());
        property.setEnum(enums);
        return property;
    }

    private String getTagName(ControllerModel controller) {
        if (this._config.isTagDescriptionAsName() && controller.getDescription() != null && !controller.getDescription().isEmpty()) {
            return TextUtils.getFirstLine((String)controller.getDescription());
        }
        return this._config.getTypeNameParser().parse((Type)controller.getControllerClass());
    }

    private void hideEmptyController(Swagger swagger) {
        if (swagger.getPaths() == null) {
            return;
        }
        HashSet tags = new HashSet();
        for (Path path : swagger.getPaths().values()) {
            if (path.getGet() != null) {
                tags.addAll(path.getGet().getTags());
            }
            if (path.getPost() != null) {
                tags.addAll(path.getPost().getTags());
            }
            if (path.getPut() != null) {
                tags.addAll(path.getPut().getTags());
            }
            if (path.getDelete() != null) {
                tags.addAll(path.getDelete().getTags());
            }
            if (path.getOptions() != null) {
                tags.addAll(path.getOptions().getTags());
            }
            if (path.getHead() != null) {
                tags.addAll(path.getHead().getTags());
            }
            if (path.getPatch() == null) continue;
            tags.addAll(path.getPatch().getTags());
        }
        Iterator iterator = swagger.getTags().iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (tags.stream().filter(o -> o.equals(tag.getName())).findFirst().isPresent()) continue;
            iterator.remove();
        }
    }
}

