package cn.wjee.commons.collection;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.util.HashMap;
import java.util.Map;

/**
 * Map Builder工具
 *
 * @author listening
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class MapBuilder<K, V> {
    private final Map<K, V> map = new HashMap<>();

    public static <K, V> MapBuilder<K, V> of(K key, V value) {
        return new MapBuilder<K, V>().put(key, value);
    }

    public MapBuilder<K, V> put(K key, V value) {
        map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> putAll(Map<K, V> addMap) {
        map.putAll(addMap);
        return this;
    }

    public MapBuilder<K, V> remove(K key) {
        map.remove(key);
        return this;
    }

    public MapBuilder<K, V> clear() {
        map.clear();
        return this;
    }

    public Map<K, V> ok() {
        return map;
    }
}
