package cn.wjee.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/**
 * 多值MAP
 *
 * @author lxn
 */
public class MultiMap<K, V> extends HashMap<K, List<V>> {
    /**
     * 添加元素
     *
     * @param k Key
     * @param v Value
     * @return MultiMap
     */
    public MultiMap<K, V> add(K k, V v) {
        computeIfAbsent(k, t -> new ArrayList<>()).add(v);
        return this;
    }

    /**
     * 添加元素
     *
     * @param k  Key
     * @param vs Value集合
     * @return MultiMap
     */
    public MultiMap<K, V> addAll(K k, Collection<V> vs) {
        computeIfAbsent(k, t -> new ArrayList<>()).addAll(vs);
        return this;
    }

    /**
     * 移除元素
     *
     * @param k  Key
     * @param vs Value集合
     * @return MultiMap
     */
    public MultiMap<K, V> delete(K k, Collection<V> vs) {
        computeIfAbsent(k, t -> new ArrayList<>()).removeAll(vs);
        return this;
    }

    /**
     * 移除元素
     *
     * @param k Key
     * @param v Value
     * @return MultiMap
     */
    public MultiMap<K, V> delete(K k, V v) {
        computeIfAbsent(k, t -> new ArrayList<>()).remove(v);
        return this;
    }

    /**
     * 获取最后一个元素
     *
     * @param k Key
     * @return V
     */
    public V getLast(K k) {
        List<V> vs = computeIfAbsent(k, t -> new ArrayList<>());
        return vs == null || vs.isEmpty() ? null : vs.get(vs.size() - 1);
    }

    /**
     * 获取第一个元素
     *
     * @param k Key
     * @return V
     */
    public V getFirst(K k) {
        List<V> vs = computeIfAbsent(k, t -> new ArrayList<>());
        return vs == null || vs.isEmpty() ? null : vs.get(0);
    }

    /**
     * 是够包含某个值
     *
     * @param k Key
     * @param v Value
     * @return boolean
     */
    public boolean containsValue(K k, V v) {
        return computeIfAbsent(k, t -> new ArrayList<>()).contains(v);
    }
}
