package cn.wjee.commons.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

/**
 * Optional方法
 *
 * @author wjee
 */
public class Optionals {

    private Optionals() {
    }

    /**
     * 根据参数动态查List
     *
     * @param coll 参数列表
     * @param func 回调函数
     * @param <T>  泛型入
     * @param <R>  泛型出
     * @return List
     */
    public static <T, R> List<R> forList(List<T> coll, Function<List<T>, List<R>> func) {
        return coll != null && !coll.isEmpty() ? func.apply(coll) : new ArrayList<>();
    }

    /**
     * 根据Set参数动态查List
     *
     * @param coll 参数列表
     * @param func 回调函数
     * @param <T>  泛型入
     * @param <R>  泛型出
     * @return List
     */
    public static <T, R> List<R> forList(Set<T> coll, Function<Set<T>, List<R>> func) {
        return coll != null && !coll.isEmpty() ? func.apply(coll) : new ArrayList<>();
    }

    /**
     * 根据参数动态查对象列表
     *
     * @param id   参数
     * @param func 回调转换函数
     * @param <T>  参数泛型
     * @param <R>  返回泛型
     * @return List
     */
    public static <T, R> List<R> forList(T id, Function<T, List<R>> func) {
        return id != null ? func.apply(id) : null;
    }

    /**
     * 根据参数动态查对象
     *
     * @param id   参数
     * @param func 回调转换函数
     * @param <T>  参数泛型
     * @param <R>  返回泛型
     * @return R
     */
    public static <T, R> R forObject(T id, Function<T, R> func) {
        return id != null ? func.apply(id) : null;
    }


}
