package cn.wjee.commons.collection;

import cn.wjee.commons.convert.ConvertTemplate;
import cn.wjee.commons.lang.DateUtils;
import cn.wjee.commons.lang.DecimalUtils;
import cn.wjee.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

/**
 * Request Map
 *
 * @author listening
 */
public class RequestMap extends HashMap<String, Object> {

    private static final long serialVersionUID = 5365309801392120148L;

    @Override
    public RequestMap put(String k, Object v) {
        super.put(k, v);
        return this;
    }

    /**
     * 取值String
     *
     * @param key 字段名
     * @return String
     */
    public String getValue(String key) {
        return ConvertTemplate.convert(get(key), String.class);
    }

    /**
     * 取值Integer
     *
     * @param code 字段
     * @return Integer
     */
    public Integer getInt(String code) {
        String value = getValue(code);
        return StringUtils.getIntValue(value, null);
    }

    /**
     * 取值Long
     *
     * @param code 字段
     * @return Long
     */
    public Long getLong(String code) {
        String value = getValue(code);
        return StringUtils.getLongValue(value, null);
    }

    /**
     * 取值Decimal
     *
     * @param code 字段
     * @return BigDecimal
     */
    public BigDecimal getDecimal(String code) {
        String value = getValue(code);
        return DecimalUtils.getDecimal(value);
    }

    /**
     * 查询日期类型
     *
     * @param code   参数
     * @param format 格式
     * @return Date
     */
    public Date getDate(String code, String format) {
        String value = getValue(code);
        return DateUtils.parse(value, format);
    }

}
