package cn.wjee.commons.collection;

import java.util.Objects;

/**
 * Tuple2
 *
 * @author listening
 */
@SuppressWarnings("all")
public class Tuple2<T0, T1> {
    public T0 f0;
    public T1 f1;

    public Tuple2() {
    }

    public Tuple2(T0 f0, T1 f1) {
        this.f0 = f0;
        this.f1 = f1;
    }

    public static <T0, T1> Tuple2<T0, T1> of(T0 t0, T1 t1) {
        Tuple2<T0, T1> tuple = new Tuple2<>();
        tuple.f0 = t0;
        tuple.f1 = t1;
        return tuple;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple2)) {
            return false;
        }
        @SuppressWarnings("rawtypes")
        Tuple2 tuple = (Tuple2) o;
        if (!Objects.equals(f0, tuple.f0)) {
            return false;
        }
        return Objects.equals(f1, tuple.f1);
    }

    @Override
    public int hashCode() {
        int result = f0 != null ? f0.hashCode() : 0;
        result = 31 * result + (f1 != null ? f1.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Tuple2{" +
            "f0=" + f0 +
            ", f1=" + f1 +
            '}';
    }
}
