package cn.wjee.commons.collection;

import java.util.Objects;

/**
 * Tuple3
 *
 * @author listening
 */
@SuppressWarnings("all")
public class Tuple3<T0, T1, T2> {
    public T0 f0;
    public T1 f1;
    public T2 f2;

    public Tuple3() {
    }

    public Tuple3(T0 f0, T1 f1, T2 f2) {
        this.f0 = f0;
        this.f1 = f1;
        this.f2 = f2;
    }

    public static <T0, T1, T2> Tuple3<T0, T1, T2> of(T0 t0, T1 t1, T2 t2) {
        Tuple3<T0, T1, T2> tuple = new Tuple3<>();
        tuple.f0 = t0;
        tuple.f1 = t1;
        tuple.f2 = t2;
        return tuple;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple3)) {
            return false;
        }
        @SuppressWarnings("rawtypes")
        Tuple3 tuple = (Tuple3) o;
        if (!Objects.equals(f0, tuple.f0)) {
            return false;
        }
        if (!Objects.equals(f1, tuple.f1)) {
            return false;
        }
        return Objects.equals(f2, tuple.f2);
    }

    @Override
    public int hashCode() {
        int result = f0 != null ? f0.hashCode() : 0;
        result = 31 * result + (f1 != null ? f1.hashCode() : 0);
        result = 31 * result + (f2 != null ? f2.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Tuple3{" +
            "f0=" + f0 +
            ", f1=" + f1 +
            ", f2=" + f2 +
            '}';
    }
}
