package cn.wjee.commons.constants;

/**
 * 字符常量
 *
 * @author listening
 */
public class Vars {
    private Vars() {
    }

    /**
     * 特殊符号相关
     */
    public static final String ALL = "*";
    public static final String ANT_ALL = "**";
    public static final String DOT = ".";
    public static final String QUESTION = "?";
    public static final String SEMICOLON = ";";
    public static final String HYPHEN = "-";
    public static final String RMB = "¥";
    public static final String WRAP = "\n";
    public static final String WIN_FILE_SEPARATOR = "\\";
    public static final String SEPARATOR = "/";
    public static final String EQ = "=";
    public static final String GT = ">";
    public static final String LT = "<";
    public static final String LTE = "<=";
    public static final String GTE = ">=";
    public static final String NE = "!=";
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    /**
     * IP 地址相关
     */
    public static final String LOCAL_HOST = "localhost";
    public static final String LOCAL_IP = "127.0.0.1";
    /**
     * 文件相关
     */
    public static final String XLSX = ".xlsx";
    public static final String PROPERTIES = ".properties";
    public static final String UNKNOWN = "unknown";
    /**
     * 数字相关
     */
    public static final String ZERO = "0";
    public static final String ONE = "1";

    /**
     * 路径相关
     */
    public static final String ANT_PATH_STATIC = "/static/**";
    public static final String ANT_PATH_WEBJARS = "/webjars/**";
    public static final String ANT_PATH_SWAGGER3 = "/v3/api-docs/**";
    public static final String ANT_PATH_SWAGGER_UI = "/swagger-ui/**";
    public static final String ANT_PATH_DOC_H5 = Vars.SEPARATOR + "doc.html";

    /**
     * DB相关
     */
    public static final String MYSQL_CONN_PARAMS = "useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=GMT%2B8&zeroDateTimeBehavior=convertToNull&allowPublicKeyRetrieval=true";

}
