package cn.wjee.commons.convert;

import cn.wjee.commons.exception.BusinessException;
import cn.wjee.commons.functional.Converter;

import java.util.HashMap;
import java.util.Map;

/**
 * 转换工具
 *
 * @author lxn
 */
public class ConvertTemplate {
    private ConvertTemplate() {
    }

    private static final Map<Class<?>, Converter<?>> CONVERTERS = new HashMap<>();

    static {
        CONVERTERS.put(String.class, new StringConverter());
    }

    public static <T> T convert(Object value, Class<T> clz) {
        Converter<?> converter = CONVERTERS.get(clz);
        if (converter == null) {
            throw new BusinessException(400, "不支持的类型");
        }
        @SuppressWarnings("unchecked") Converter<T> mappedConverter = (Converter<T>) converter;
        return mappedConverter.accept(value);
    }
}
