package cn.wjee.commons.convert;

import cn.wjee.commons.crypto.EncodeUtils;
import cn.wjee.commons.functional.Converter;
import cn.wjee.commons.lang.DateUtils;

import java.util.Date;

/**
 * 对象转字符串
 *
 * @author lxn
 */
class StringConverter implements Converter<String> {

    @Override
    public String accept(Object value) {
        if (value instanceof CharSequence) {
            return value.toString();
        }

        if (value instanceof Number) {
            Number num = (Number) value;
            return String.valueOf(num);
        }

        if (value instanceof Date) {
            return DateUtils.datetime2string((Date) value);
        }

        if (value instanceof byte[]) {
            return EncodeUtils.getString((byte[]) value);
        }

        return null;
    }
}
