package cn.wjee.commons.crypto;

import cn.wjee.commons.lang.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 编码工具类 实现aes加密、解密
 *
 * @author listening
 */
public class AesUtils {
    private AesUtils() {
    }

    /**
     * 日志
     */
    private static final Logger log = LoggerFactory.getLogger(AesUtils.class);

    /**
     * 使用AES进行加密
     *
     * @param content 内容
     * @param key     秘钥
     * @return String 加密后转Base64
     */
    public static String encrypt(String content, String key) {
        return AES.newCipherEcb(key).encrypt(content);
    }

    /**
     * 使用AES进行解密
     *
     * @param content 内容
     * @param key     秘钥
     * @return String   解密后的内容
     */
    public static String decrypt(String content, String key) {
        return AES.newCipherEcb(key).decrypt(content);
    }

    public static void newAESKey() {
        log.info("AES::KEY::{}", RandomUtils.getRandom(16, true));
    }
}
