package cn.wjee.commons.crypto;

import cn.wjee.commons.exception.BizException;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

/**
 * MD5工具
 *
 * @author listening
 */
public class Md5Utils {

    private Md5Utils() {

    }

    /**
     * MD5 Encrypt
     *
     * @param info 待加密字符串
     * @return String
     */
    public static String encrypt(String info) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(info.getBytes(StandardCharsets.UTF_8));
            BigInteger tempDigest = new BigInteger(1, md5.digest());
            return tempDigest.toString(16).toUpperCase(Locale.ROOT);
        } catch (NoSuchAlgorithmException e) {
            throw new BizException("MD5 fail", e);
        }
    }

    /**
     * 16位MD5, 中间截取
     *
     * @param info 待加密内容
     * @return String
     */
    public static String encrypt16bit(String info) {
        return encrypt(info).substring(9, 25);
    }
}
