package cn.wjee.commons.crypto;

import cn.wjee.commons.exception.Asserts;
import cn.wjee.commons.lang.StringUtils;

import java.math.BigInteger;

/**
 * 进制加解码工具类
 *
 * @author listening
 */
public class RadixUtils {
    private RadixUtils() {
    }

    /**
     * 码表
     */
    private static final String STANDARD_ENCODE_TABLE_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final char[] STANDARD_ENCODE_TABLE = STANDARD_ENCODE_TABLE_STRING.toCharArray();

    /**
     * 进制编码
     *
     * @param num   数字
     * @param radix 进制
     * @return String
     */
    public static String encode(Long num, Integer radix) {
        Asserts.isTrue(radix >= 2 && radix <= 62, "进制参数必须在2进制到62进制");
        StringBuilder builder = new StringBuilder();
        Long tempNum = num;
        while (tempNum > 0) {
            int index = Integer.parseInt(String.valueOf(tempNum % radix));
            builder.append(STANDARD_ENCODE_TABLE[index]);
            tempNum = tempNum / radix;
        }
        return builder.reverse().toString();
    }

    /**
     * 进制解码
     *
     * @param value 待解码字符串
     * @param radix 进制
     * @return String
     */
    public static String decode(String value, Integer radix) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        char[] valueCharArray = value.toCharArray();
        long result = 0L;
        BigInteger radixBigInteger = new BigInteger(radix + "");
        for (int i = 0; i < valueCharArray.length; i++) {
            int index = STANDARD_ENCODE_TABLE_STRING.indexOf(value.toCharArray()[i]);
            result += index * radixBigInteger.pow(valueCharArray.length - i - 1).longValue();
        }
        return result + "";
    }
}
