package cn.wjee.commons.crypto;

import lombok.Getter;

/**
 * RSA加密算法类型枚举
 *
 * @author listening
 */
@Getter
public enum RsaType {
    /**
     * 1024位秘钥RSA加密
     */
    RSA("RSA", 1024, 117, 128, "MD5withRSA"),
    /**
     * 2048位秘钥RSA加密
     */
    RSA2("RSA", 2048, 245, 256, "SHA256WithRSA");
    /**
     * KeyFactory算法，默认RSA
     */
    private final String keyAlgorithm;
    /**
     * 秘钥长度
     */
    private final int keySize;
    /**
     * 加密块大小(大于则需要分段加密)
     */
    private final int maxEncryptBlock;
    /**
     * RSA最大解密块大小
     */
    private final int maxDecryptBlock;
    /**
     * 加签算法
     */
    private final String signatureAlgorithm;

    RsaType(String keyAlgorithm, int keySize, int maxEncryptBlock, int maxDecryptBlock, String signatureAlgorithm) {
        this.maxEncryptBlock = maxEncryptBlock;
        this.maxDecryptBlock = maxDecryptBlock;
        this.keyAlgorithm = keyAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
        this.keySize = keySize;
    }
}
