package cn.wjee.commons.crypto;

import cn.wjee.commons.collection.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * RSA 加密解密工具类
 *
 * @author wjee
 * @version $Id: RSAUtils.java, v 0.1 2015年11月8日 下午4:54:10 wjee Exp $
 */
public class RsaUtils {
    /**
     * 日志
     */
    private static final Logger log = LoggerFactory.getLogger(RsaUtils.class);

    private RsaUtils() {
    }

    /**
     * 用私钥解密
     *
     * @param value 密文
     * @param key   密钥
     * @return String
     * @throws Exception RSA异常
     */
    public static String decryptByPrivateKey(String value, String key) throws Exception {
        return RSA.newRsa().decryptByPrivateKey(value, key);
    }

    /**
     * 用公钥加密
     *
     * @param value 要加密数据
     * @param key   密钥
     * @return byte[]
     * @throws Exception RSA异常
     */
    public static String encryptByPublicKey(String value, String key) throws Exception {
        return RSA.newRsa().encryptByPublicKey(value, key);
    }

    /**
     * 用私钥对信息生成数字签名
     *
     * @param data       加密数据
     * @param privateKey 私钥
     * @return String
     * @throws Exception RSA异常
     */
    public static String sign(String data, String privateKey) throws Exception {
        return RSA.newRsa().sign(data, privateKey);
    }

    /**
     * 用公钥验证数据签名
     *
     * @param data      报文数据
     * @param sign      签名
     * @param publicKey 公钥
     * @return boolean
     * @throws Exception 验签异常
     */
    public static boolean verifySign(String data, String sign, String publicKey) throws Exception {
        return RSA.newRsa().verifySign(data, sign, publicKey);
    }

    /**
     * 获取RSA
     *
     * @return RSA
     */
    public static RSA getRsa() {
        return RSA.newRsa();
    }

    public static void rsaTest()  {
        RSA rsa = RSA.newRsa();
        String data = "123";
        Tuple2<String,String> tuple = rsa.newRsaKeys();
        String privateKey = tuple.f0;
        String publicKey = tuple.f1;
        log.info("私钥：{}", privateKey);
        log.info("公钥：{}", publicKey);
        String encodeValue = rsa.encryptByPublicKey(data, publicKey);
        log.info("公钥加密: {}", encodeValue);
        String decryptValue = rsa.decryptByPrivateKey(encodeValue, privateKey);
        log.info("私钥解密: {}", decryptValue);
        String sign = rsa.sign(data, privateKey);
        log.info("私钥加签：{}", sign);
        log.info("公钥验签：{}", rsa.verifySign(data, sign, publicKey));
    }
}
