package cn.wjee.commons.domain;

import cn.wjee.commons.exception.Asserts;
import cn.wjee.commons.lang.StringUtils;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 加密请求体
 * <p>
 * 1. 双方交换公钥
 * 2. 随机生成AES密钥，用密钥将业务参数加密（bizData）
 * 3. 用对方公钥将AES密钥加密(key)
 *
 * @author listening
 */
@Data
public class ApiBody {
    /**
     * 字段名常量
     */
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_APP_ID = "appId";
    public static final String FIELD_NON_STR = "nonStr";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_BIZ_DATA = "bizData";
    public static final String FIELD_SECRET_KEY = "secretKey";
    public static final String FIELD_SIGN = "sign";

    /**
     * 版本号
     */
    private String version;
    /**
     * APP Key
     */
    private String appId;
    /**
     * 随机字符串
     */
    private String nonStr;
    /**
     * 请求时间戳(毫秒)
     */
    private String timestamp;
    /**
     * 业务参数AES加密参数(AES密钥从key解密)
     */
    private String bizData;
    /**
     * AES密钥RSA加密后的结果
     */
    private String secretKey;
    /**
     * 签名
     */
    private String sign;

    public Map<String, String> toMap() {
        Map<String, String> map = new HashMap<>(7);
        // Version
        String tempVersion = StringUtils.getValue(getVersion());
        Asserts.notBlank(tempVersion, "签名错误, version不能为空");
        map.put(FIELD_VERSION, tempVersion);
        // AppId
        String tempAppId = StringUtils.getValue(getAppId());
        Asserts.notBlank(tempAppId, "签名错误, appId不能为空");
        map.put(FIELD_APP_ID, tempAppId);
        // NonStr
        String tempNonStr = StringUtils.getValue(getNonStr());
        Asserts.notBlank(tempNonStr, "签名错误, nonStr不能为空");
        map.put(FIELD_NON_STR, tempNonStr);
        // Timestamp
        String tempTimestamp = StringUtils.getValue(getTimestamp());
        Asserts.notBlank(tempTimestamp, "签名错误, timestamp不能为空");
        long tempTimestampLong = Long.parseLong(tempTimestamp);
        Asserts.isTrue(Math.abs(System.currentTimeMillis() - tempTimestampLong) < 15 * 60 * 1000L, "签名错误,请求时间戳过期");
        map.put(FIELD_TIMESTAMP, tempTimestamp);
        // BizData
        String tempBizData = StringUtils.getValue(getBizData());
        Asserts.notBlank(tempBizData, "签名错误, bizData不能为空");
        map.put(FIELD_BIZ_DATA, tempBizData);
        // Sign|SecurityKey
        map.put(FIELD_SECRET_KEY, StringUtils.getValue(getSecretKey()));
        map.put(FIELD_SIGN, StringUtils.getValue(getSign()));
        return map;
    }
}
