package cn.wjee.commons.domain;

import cn.wjee.commons.enums.TokenTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.HashMap;
import java.util.Map;

/**
 * User Claim for JWT
 *
 * @author listening
 */
@Data
@Accessors(chain = true)
public class JwtUserClaim {
    /**
     * Token类型
     */
    private TokenTypeEnum tokenType = TokenTypeEnum.ACCESS_TOKEN;
    /**
     * Token颁发者
     */
    private String iss = "";
    /**
     * 用户ID(用于subject)
     */
    private String userId = "";
    /**
     * 用户IP(用于audience)
     */
    private String clientIp = "";
    /**
     * 其他扩展参数
     */
    private Map<String, Object> extClaimMap = new HashMap<>();

    /**
     * 添加扩展参数
     *
     * @param key   参数Key
     * @param value 参数Value
     * @return JwtUserClaim
     */
    public JwtUserClaim addExtClaim(String key, String value) {
        extClaimMap.put(key, value);
        return this;
    }
}
