package cn.wjee.commons.domain;

import java.util.ArrayList;
import java.util.List;

/**
 * 分页工具类
 *
 * @author wjee
 * @version $Id: Pagination.java, v 0.1 2014年7月21日 下午6:56:06 wjee Exp $
 */
public class Pagination<T> {
    /**
     * 页码
     */
    private Integer pageNo = 1;
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    /**
     * 记录总数
     */
    private Integer total = 0;
    /**
     * 列表记录
     */
    private List<T> rows = new ArrayList<>();

    public Pagination() {

    }

    public Pagination(Integer pageNo, Integer pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public Pagination(Paging paging) {
        this(paging.getPageNo(), paging.getPageSize());
    }

    public void setData(Integer total, List<T> dataList) {
        this.total = total;
        this.rows = dataList;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public Integer getTotal() {
        return total;
    }

    public List<T> getRows() {
        return rows;
    }

    public Integer getTotalPage() {
        return total % pageSize == 0 ? (total / pageSize) : (total / pageSize + 1);
    }
}
