package cn.wjee.commons.domain;

import lombok.Getter;
import lombok.Setter;

/**
 * 分页信息
 *
 * @author WJee
 * @version $Id: Page.java, v 0.1 2014年7月20日 下午6:36:23 WJee Exp $
 */
@Getter
@Setter
public class Paging {
    /**
     * 页码
     */
    private Integer page;

    /**
     * 页面大小
     */
    private Integer limit;

    public Paging() {

    }

    public Paging(Integer pageNo, Integer pageSize) {
        this.page = pageNo;
        this.limit = pageSize;
    }

    public static Paging of(Integer pageNo, Integer pageSize) {
        return new Paging(pageNo, pageSize);
    }

    public Integer getPageNo() {
        return page != null && page > 0 ? page : 1;
    }

    public Integer getPageSize() {
        return limit != null && limit > 0 ? limit : 20;
    }
}
