package cn.wjee.commons.domain;

/**
 * 版本比对
 *
 * @author listening
 */
public class Version implements Comparable<Version> {

    protected final int majorVersion;

    protected final int minorVersion;

    protected final int patchLevel;

    protected final String snapshotInfo;

    public Version(int major, int minor, int patchLevel, String snapshotInfo) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.patchLevel = patchLevel;
        this.snapshotInfo = snapshotInfo;
    }

    public boolean isSnapshot() {
        return this.snapshotInfo != null && this.snapshotInfo.length() > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(majorVersion).append('.');
        sb.append(minorVersion).append('.');
        sb.append(patchLevel);
        if (isSnapshot()) {
            sb.append('-').append(snapshotInfo);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Version version = (Version) o;

        if (majorVersion != version.majorVersion) return false;
        if (minorVersion != version.minorVersion) return false;
        if (patchLevel != version.patchLevel) return false;
        return snapshotInfo.equals(version.snapshotInfo);
    }

    @Override
    public int hashCode() {
        int result = majorVersion;
        result = 31 * result + minorVersion;
        result = 31 * result + patchLevel;
        result = 31 * result + snapshotInfo.hashCode();
        return result;
    }

    @Override
    public int compareTo(Version other) {
        if (other == this || other == null) {
            return 0;
        }

        int diff = majorVersion - other.majorVersion;
        if (diff != 0) {
            return diff;
        }

        diff = minorVersion - other.minorVersion;
        if (diff != 0) {
            return diff;
        }

        diff = patchLevel - other.patchLevel;
        if (diff != 0) {
            return diff;
        }

        boolean snapshot = isSnapshot();
        boolean otherSnapshot = other.isSnapshot();

        if (snapshot && !otherSnapshot) {
            return -1;
        }
        if (!snapshot && otherSnapshot) {
            return 1;
        }
        return 0;
    }
}
