package cn.wjee.commons.enums;

import cn.wjee.commons.exception.BusinessException;
import cn.wjee.commons.exception.ICodeEnum;
import lombok.Getter;

import java.text.MessageFormat;

/**
 * 接口状态枚举
 *
 * @author listening
 */
@Getter
public enum ApiStatusEnum implements ICodeEnum {
    /**
     * Common错误码
     */
    SUCCESS(200, "成功", "请求成功!"),
    FAILURE_400(400, "参数缺失", "对不起，您的请求参数不正确!"),
    FAILURE_401(401, "登陆超时", "对不起，您的登录已超时，请重新登录!"),
    FAILURE_403(403, "访问权限受限", "对不起，您的访问权限不足!"),
    FAILURE_403_DOMAIN(403, "访问域名受限", "当前域名无访问权限"),
    FAILURE_404(404, "资源不存在", "对不起，您请求的资源不存在!"),
    FAILURE_405(405, "请求方法不支持", "对不起，您请求的方法不支持!"),
    FAILURE_415(415, "参数格式不正确", "对不起，您的请求参数格式不正确!"),
    FAILURE_429(429, "访问过快", "访问太快了，休息一下吧"),
    FAILURE_500(500, "系统服务异常", "对不起，您的请求处理失败!"),
    /**
     * 一般状态码
     */
    FAILURE(1000, "失败", "对不起，您的请求处理失败, 请稍后再试!"),
    FAILURE_RANDOM(1001, "验证码不正确", "对不起，您的验证码不正确!"),
    FAILURE_NOT_EXIST(1002, "记录不存在", "对不起，您请求的记录不存在!"),
    FAILURE_BAT_VERSION(1003, "版本不匹配", "对不起，您的请求处理失败!"),

    /**
     * 安全验证类
     */
    FAILURE_SIGN(2000, "签名不正确", "对不起，您的签名不正确!"),
    FAILURE_DECRYPT(2001, "请求解密失败", "对不起，请求解密错误!"),
    FAILURE_ENCRYPT(2002, "返回加密失败", "对不起，返回加密错误!"),
    FAILURE_DOC_DUMMY_CIPHER(2003, "文档模拟密文不正确", "对不起，文档模拟密文不正确!"),

    /**
     * 系统登录
     */
    FAILURE_LOGIN_ACCOUNT_LOCKED(2004, "用户被锁定", "连续失败次数过多, 您的账号已被锁定{0}分钟"),
    FAILURE_LOGIN_ACCOUNT_DISABLED(2005, "用户禁用", "您的账号已被禁用，请联系管理员!"),
    FAILURE_LOGIN_ACCOUNT_EXPIRED(2006, "密码过期", "您的密码已过期, 请联系管理员!"),
    FAILURE_LOGIN_ACCOUNT_WRONG(2007, "账号密码不对", "您账号或密码不正确, 请核对后重试!"),
    ;

    private final Integer code;
    private final String desc;
    private final String warnMsg;

    ApiStatusEnum(Integer code, String desc, String warnMsg) {
        this.code = code;
        this.desc = desc;
        this.warnMsg = warnMsg;
    }

    @Override
    public String getMessage() {
        return getWarnMsg();
    }

    @Override
    public BusinessException toEx(Object... params) {
        String msg = MessageFormat.format(this.warnMsg, params);
        return new BusinessException(this.code, msg);
    }

    public String getStringCode() {
        return String.valueOf(code);
    }
}
