package cn.wjee.commons.enums;

import lombok.Getter;

import static java.util.Arrays.stream;

/**
 * 是否枚举
 *
 * @author listening
 */
@Getter
public enum BooleanEnum {
    /**
     * 是
     */
    TRUE(1, "是"),
    /**
     * 否
     */
    FALSE(0, "否"),
    ;

    private final Integer code;
    private final String desc;

    BooleanEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Byte getByteCode() {
        return Byte.parseByte(getCode() + "");
    }

    public static BooleanEnum getByCode(Integer code) {
        return stream(BooleanEnum.values()).filter(item -> item.isMatch(code)).findFirst().orElse(null);
    }

    /**
     * 给定编码，是否等于此枚举项
     *
     * @param code 编码值
     * @return boolean
     */
    public boolean isMatch(Integer code) {
        return getCode().equals(code);
    }

    public boolean isMatch(Byte code) {
        return code != null && getCode().equals(Integer.parseInt(code + ""));
    }

    /**
     * 判断给定值是否在枚举中定义
     *
     * @param code 编码值
     * @return boolean
     */
    public static boolean isAny(Integer code) {
        return getByCode(code) != null;
    }

    public static boolean isAny(Byte code) {
        return code != null && isAny(Integer.parseInt(code + ""));
    }

    /**
     * 根据编码查询名称
     *
     * @param code 编码
     * @return String
     */
    public static String getNameByCode(Integer code) {
        BooleanEnum statusEnum = getByCode(code);
        return statusEnum != null ? statusEnum.getDesc() : null;
    }

}
