package cn.wjee.commons.enums;

import cn.wjee.commons.lang.StringUtils;
import lombok.Getter;

import static java.util.Arrays.stream;

/**
 * 是否枚举
 *
 * @author listening
 */
@Getter
public enum DeleteEnum {
    /**
     * 已删除
     */
    DELETED(1, "已删除"),
    /**
     * 未删除
     */
    NOT_DELETED(0, "未删除"),
    ;

    private final Integer code;
    private final String desc;

    DeleteEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Byte getByteCode() {
        return Byte.parseByte(getCode() + "");
    }

    public static DeleteEnum getByCode(String code) {
        return stream(DeleteEnum.values()).filter(item -> item.isMatch(code)).findFirst().orElse(null);
    }

    /**
     * 给定编码，是否等于此枚举项
     *
     * @param code 编码值
     * @return boolean
     */
    public boolean isMatch(String code) {
        return StringUtils.isNotBlank(code) && StringUtils.equals(code, getCode() + "");
    }

    /**
     * 判断给定值是否在枚举中定义
     *
     * @param code 编码值
     * @return boolean
     */
    public static boolean isAny(String code) {
        return getByCode(code) != null;
    }

    /**
     * 根据编码查询名称
     *
     * @param code 编码
     * @return String
     */
    public static String getNameByCode(String code) {
        DeleteEnum statusEnum = getByCode(code);
        return statusEnum != null ? statusEnum.getDesc() : null;
    }

}
